/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.creategiftpk.ui.adapter;

import android.app.Activity;
import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.trello.rxlifecycle2.LifecycleTransformer;
import com.yy.mobile.creategiftpk.R;
import com.yy.mobile.creategiftpk.core.IGiftPkCore;
import com.yy.mobile.creategiftpk.diffutil.DiffUtil;
import com.yy.mobile.creategiftpk.ui.adapter.RecycleViewAdapterCompat;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.liveapi.gift.ExternalPaidGiftConfig;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.List;

public class GiftListAdapter
extends RecycleViewAdapterCompat<PaidGiftWraper> {
    Activity mContext;
    List<PaidGiftWraper> giftList = new ArrayList<PaidGiftWraper>();
    int mSelectedPosition = -1;
    public int team;
    RecyclerView mRv;
    LifecycleTransformer<DiffUtil.DiffResult> transformer;

    public void setTeam(int team) {
        this.team = team;
    }

    public void setRv(RecyclerView mRv) {
        this.mRv = mRv;
    }

    public GiftListAdapter(Activity mcontext, LifecycleTransformer<DiffUtil.DiffResult> transformer) {
        this.mContext = mcontext;
        this.transformer = transformer;
    }

    public void updateGiftList(List<ExternalPaidGiftConfig> list) {
        this.mSelectedPosition = -1;
        if (list.size() == 0) {
            this.giftList.clear();
            this.notifyDataSetChanged();
            return;
        }
        MLog.info((Object)"GiftListAdapter", (String)"->updateGiftList", (Object[])new Object[0]);
        final ArrayList<PaidGiftWraper> newList = new ArrayList<PaidGiftWraper>();
        for (int i = 0; i < list.size(); ++i) {
            PaidGiftWraper wraper = new PaidGiftWraper();
            wraper.builder(list.get(i));
            ExternalPaidGiftConfig giftBule = ((IGiftPkCore)ICoreManagerBase.getCore(IGiftPkCore.class)).getSelectGiftOfTeamBlue();
            ExternalPaidGiftConfig giftYellow = ((IGiftPkCore)ICoreManagerBase.getCore(IGiftPkCore.class)).getSelectGiftOfTeamYellow();
            if (this.team == 0) {
                if (giftBule != null && giftBule.type != null && giftBule.type.equals(wraper.type)) {
                    wraper.isSelected = true;
                    this.mSelectedPosition = i;
                } else if (giftYellow != null && giftYellow.type != null && giftYellow.type.equals(wraper.type)) {
                    wraper.isSelected = false;
                    wraper.update = true;
                }
            } else if (giftYellow != null && giftYellow.type != null && giftYellow.type.equals(wraper.type)) {
                wraper.isSelected = true;
                this.mSelectedPosition = i;
            } else if (giftBule != null && giftBule.type != null && giftBule.type.equals(wraper.type)) {
                wraper.isSelected = false;
                wraper.update = true;
            }
            newList.add(wraper);
        }
        Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<DiffUtil.DiffResult>(){

            public void subscribe(@NonNull ObservableEmitter<DiffUtil.DiffResult> e) {
                try {
                    DiffUtil.DiffResult result = DiffUtil.calculateDiff(new GiftDiff(GiftListAdapter.this.giftList, newList));
                    e.onNext((Object)result);
                }
                catch (Exception ex) {
                    MLog.error((Object)"GiftListAdpater", (Throwable)ex);
                }
            }
        }).subscribeOn(Schedulers.computation()).compose(this.transformer).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<DiffUtil.DiffResult>(){

            public void accept(@NonNull DiffUtil.DiffResult diffResult) {
                try {
                    diffResult.dispatchUpdatesTo(GiftListAdapter.this);
                    if (GiftListAdapter.this.mSelectedPosition > 0) {
                        GiftListAdapter.this.mRv.scrollToPosition(GiftListAdapter.this.mSelectedPosition);
                    }
                    GiftListAdapter.this.giftList.clear();
                    GiftListAdapter.this.giftList.addAll(newList);
                }
                catch (Exception ex) {
                    MLog.error((Object)"GiftListAdpater", (Throwable)ex);
                }
            }
        });
    }

    @Override
    public int getItemCount() {
        return this.giftList.size();
    }

    @Override
    public PaidGiftWraper getItem(int position) {
        if (position >= 0 && position < this.getItemCount()) {
            return this.giftList.get(position);
        }
        return null;
    }

    @Override
    public View onCreateView(ViewGroup viewGroup, int viewType) {
        return LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_gift_item, viewGroup, false);
    }

    @Override
    public void onBindViewHolder(final RecycleViewAdapterCompat.ViewHolder holder, int position) {
        final PaidGiftWraper giftItem = this.getItem(position);
        if (giftItem == null) {
            return;
        }
        RecycleImageView ivGiftIcon = (RecycleImageView)holder.get(R.id.iv_gift_icon);
        TextView tvGiftName = (TextView)holder.get(R.id.tv_gift_name);
        TextView tvGiftPrice = (TextView)holder.get(R.id.tv_gift_price);
        Object ivSelectedTag = holder.get(R.id.iv_selected_tag);
        ImageView jiaobiaoBigGif = (ImageView)holder.get(R.id.jiaobiao_bigGif);
        if (giftItem.isSelected) {
            ivSelectedTag.setVisibility(0);
        } else {
            ivSelectedTag.setVisibility(4);
        }
        boolean isbig = giftItem.isBig;
        if (isbig) {
            jiaobiaoBigGif.setVisibility(0);
        } else {
            jiaobiaoBigGif.setVisibility(8);
        }
        ImageLoader.loadImage((RecycleImageView)ivGiftIcon, (String)giftItem.iconPath, (int)R.drawable.icon_gift_default);
        tvGiftName.setText((CharSequence)(giftItem.name == null ? "" : giftItem.name));
        if (giftItem.price != null) {
            tvGiftPrice.setText((CharSequence)this.mContext.getString(R.string.gift_price_format, new Object[]{Float.valueOf((float)giftItem.price.intValue() / 100.0f)}));
        } else {
            tvGiftPrice.setText((CharSequence)"");
        }
        holder.itemView.setOnClickListener(new View.OnClickListener((View)ivSelectedTag){
            final /* synthetic */ View val$ivSelectedTag;
            {
                this.val$ivSelectedTag = view;
            }

            public void onClick(View v) {
                MLog.info((Object)"GiftListAdapter", (String)("->click select gift pos=" + holder.getAdapterPosition()), (Object[])new Object[0]);
                if (GiftListAdapter.this.mSelectedPosition == holder.getAdapterPosition()) {
                    return;
                }
                if (GiftListAdapter.this.team == 0) {
                    if (giftItem.type != null && ((IGiftPkCore)ICoreManagerBase.getCore(IGiftPkCore.class)).getSelectGiftOfTeamYellow() != null && giftItem.type.equals(((IGiftPkCore)ICoreManagerBase.getCore(IGiftPkCore.class)).getSelectGiftOfTeamYellow().type)) {
                        Toast.makeText((Context)GiftListAdapter.this.mContext.getApplicationContext(), (CharSequence)"\u5df2\u7ecf\u88ab\u9ec4\u961f\u9009\u4e2d", (int)0).show();
                        return;
                    }
                } else if (giftItem.type != null && ((IGiftPkCore)ICoreManagerBase.getCore(IGiftPkCore.class)).getSelectGiftOfTeamBlue() != null && giftItem.type.equals(((IGiftPkCore)ICoreManagerBase.getCore(IGiftPkCore.class)).getSelectGiftOfTeamBlue().type)) {
                    Toast.makeText((Context)GiftListAdapter.this.mContext.getApplicationContext(), (CharSequence)"\u5df2\u7ecf\u88ab\u84dd\u961f\u9009\u4e2d", (int)0).show();
                    return;
                }
                if (GiftListAdapter.this.mSelectedPosition != -1) {
                    PaidGiftWraper wraper;
                    RecycleViewAdapterCompat.ViewHolder vh = (RecycleViewAdapterCompat.ViewHolder)GiftListAdapter.this.mRv.findViewHolderForLayoutPosition(GiftListAdapter.this.mSelectedPosition);
                    if (vh != null) {
                        vh.get(R.id.iv_selected_tag).setVisibility(4);
                        if (MLog.isLogLevelAboveDebug()) {
                            MLog.debug((Object)"GiftListAdapter", (String)("->onClick reset pos=" + GiftListAdapter.this.mSelectedPosition), (Object[])new Object[0]);
                        }
                    } else {
                        if (MLog.isLogLevelAboveDebug()) {
                            MLog.debug((Object)"GiftListAdapter", (String)("->onClick notifyItemChanged reset pos=" + GiftListAdapter.this.mSelectedPosition), (Object[])new Object[0]);
                        }
                        GiftListAdapter.this.notifyItemChanged(GiftListAdapter.this.mSelectedPosition);
                    }
                    if ((wraper = GiftListAdapter.this.getItem(GiftListAdapter.this.mSelectedPosition)) != null) {
                        wraper.isSelected = false;
                    }
                }
                GiftListAdapter.this.mSelectedPosition = holder.getAdapterPosition();
                giftItem.isSelected = true;
                this.val$ivSelectedTag.setVisibility(0);
                if (GiftListAdapter.this.team == 0) {
                    ((IGiftPkCore)ICoreManagerBase.getCore(IGiftPkCore.class)).saveSelectedGiftOfTeamBlue(giftItem);
                } else {
                    ((IGiftPkCore)ICoreManagerBase.getCore(IGiftPkCore.class)).saveSelectedGiftOfTeamYellow(giftItem);
                }
            }
        });
    }

    class GiftDiff
    extends DiffUtil.Callback {
        List<PaidGiftWraper> mOldList;
        List<PaidGiftWraper> mNewList;

        public GiftDiff(List<PaidGiftWraper> mOldList, List<PaidGiftWraper> mNewList) {
            this.mOldList = mOldList;
            this.mNewList = mNewList;
        }

        @Override
        public int getOldListSize() {
            return this.mOldList != null ? this.mOldList.size() : 0;
        }

        @Override
        public int getNewListSize() {
            return this.mNewList != null ? this.mNewList.size() : 0;
        }

        @Override
        public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
            PaidGiftWraper oldWraper = this.mOldList.get(oldItemPosition);
            PaidGiftWraper newWraper = this.mNewList.get(newItemPosition);
            return oldWraper != null && newWraper != null && oldWraper.type != null && oldWraper.type.equals(newWraper.type);
        }

        @Override
        public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
            PaidGiftWraper oldWraper = this.mOldList.get(oldItemPosition);
            PaidGiftWraper newWraper = this.mNewList.get(newItemPosition);
            if (oldWraper.isSelected != newWraper.isSelected) {
                return false;
            }
            if (oldWraper.update != newWraper.update) {
                return false;
            }
            if (oldWraper.type != null && !oldWraper.type.equals(newWraper.type)) {
                return false;
            }
            if (oldWraper.price != null && !oldWraper.price.equals(newWraper.price)) {
                return false;
            }
            if (oldWraper.name != null && !oldWraper.name.equals(newWraper.name)) {
                return false;
            }
            if (oldWraper.isBig != newWraper.isBig) {
                return false;
            }
            return oldWraper.iconPath == null || oldWraper.iconPath.equals(newWraper.iconPath);
        }
    }

    static class PaidGiftWraper
    extends ExternalPaidGiftConfig {
        boolean isSelected = false;
        boolean update = false;

        PaidGiftWraper() {
        }

        ExternalPaidGiftConfig builder(ExternalPaidGiftConfig ex) {
            this.isBig = ex.isBig;
            this.price = ex.price;
            this.gifPath = ex.gifPath;
            this.grade = ex.grade;
            this.description = ex.description;
            this.iconPath = ex.iconPath;
            this.name = ex.name;
            this.type = ex.type;
            return this;
        }

        public String toString() {
            return "PaidGiftWraper{isSelected=" + this.isSelected + ",update=" + this.update + ",name=" + this.name + '}';
        }
    }
}

