/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.channelpk.coremodule.model;

import com.yy.mobile.channelpk.coremodule.core.ChannelPKProtocol;
import com.yy.mobile.channelpk.coremodule.model.InviteFriendInfo;
import com.yy.mobile.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class InviteFriendsListInfo {
    public List<InviteFriendInfo> inviteList = new ArrayList<InviteFriendInfo>();
    public HashSet<Long> uidList = new HashSet();
    public int totalCount;
    public int isEnd;
    public boolean isRankMode = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setData(ChannelPKProtocol.PCrossPKFriendRsp rsp) {
        if (rsp == null) return;
        if (rsp.extendInfo != null) {
            this.totalCount = StringUtils.safeParseInt((String)rsp.extendInfo.get("totalCount"));
            this.isEnd = StringUtils.safeParseInt((String)rsp.extendInfo.get("is_end"));
            if (rsp.extendInfo.containsKey("isRankMatch")) {
                this.isRankMode = rsp.extendInfo.get("isRankMatch").equals("1");
            }
        }
        if (rsp.dataset == null) return;
        for (int i = 0; i < rsp.dataset.size(); ++i) {
            if (this.uidList.contains(StringUtils.safeParseLong((String)rsp.dataset.get(i).get("uid")))) continue;
            InviteFriendInfo info = new InviteFriendInfo();
            info.name = rsp.dataset.get(i).get("name");
            info.uid = StringUtils.safeParseLong((String)rsp.dataset.get(i).get("uid"));
            info.pic = rsp.dataset.get(i).get("head_url");
            info.top = StringUtils.safeParseLong((String)rsp.dataset.get(i).get("top"));
            info.sub = StringUtils.safeParseLong((String)rsp.dataset.get(i).get("sub"));
            info.status = StringUtils.safeParseInt((String)rsp.dataset.get(i).get("status"));
            if (this.isRankMode) {
                if (rsp.dataset.get(i).containsKey("division")) {
                    info.division = StringUtils.safeParseInt((String)rsp.dataset.get(i).get("division"));
                }
                if (rsp.dataset.get(i).containsKey("phase")) {
                    info.phase = StringUtils.safeParseInt((String)rsp.dataset.get(i).get("phase"));
                }
                if (rsp.dataset.get(i).containsKey("starNum")) {
                    info.starNum = StringUtils.safeParseInt((String)rsp.dataset.get(i).get("starNum"));
                }
                if (rsp.dataset.get(i).containsKey("specialStyle")) {
                    info.specialStyle = StringUtils.safeParseInt((String)rsp.dataset.get(i).get("specialStyle"));
                }
            } else {
                info.division = -1;
                info.phase = -1;
                info.starNum = -1;
            }
            this.inviteList.add(info);
            this.uidList.add(info.uid);
        }
    }

    public void resetData() {
        this.inviteList.clear();
        this.uidList.clear();
        this.totalCount = 0;
        this.isEnd = 0;
    }

    public String toString() {
        return "InviteFriendsListInfo{inviteList=" + this.inviteList + ", totalCount=" + this.totalCount + ", isEnd=" + this.isEnd + '}';
    }
}

