/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.mobile.channelpk;

import com.duowan.mobile.channelpk.ModuleInfo;
import com.duowan.mobile.channelpk.PKModuleConfig;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

public class ModuleProcessor
extends AbstractProcessor {
    private Map<String, ModuleInfo> moduleMaps = new HashMap<String, ModuleInfo>();
    private Filer mFiler;
    private Elements mElementUtils;
    private Messager mMessager;
    private String packageName = "com.duowan.mobile.channelpk";
    static List<String> name = new ArrayList<String>();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.mFiler = processingEnv.getFiler();
        this.mElementUtils = processingEnv.getElementUtils();
        this.mMessager = processingEnv.getMessager();
        Map<String, String> options = processingEnv.getOptions();
        if (options != null && options.get("moduleName") != null) {
            this.packageName = options.get("moduleName");
        }
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        types.add(PKModuleConfig.class.getCanonicalName());
        return types;
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnv) {
        try {
            this.initModuleMap(roundEnv);
            this.createModuleMap(roundEnv);
            this.createModuleConstant();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private void initModuleMap(RoundEnvironment roundEnv) {
        Set<? extends Element> set = roundEnv.getElementsAnnotatedWith(PKModuleConfig.class);
        for (Element element : set) {
            if (element.getKind() == ElementKind.CLASS) {
                String clzName = element.getSimpleName().toString();
                if (this.moduleMaps.get(clzName) != null) continue;
                ModuleInfo info = new ModuleInfo(this.mElementUtils, (TypeElement)element);
                this.moduleMaps.put(clzName, info);
                continue;
            }
            this.mMessager.printMessage(Diagnostic.Kind.NOTE, "only support class");
        }
    }

    private void createModuleMap(RoundEnvironment roundEnv) throws IOException {
        TypeSpec moduleFactory = TypeSpec.enumBuilder((String)"ModuleFactory").addEnumConstant("INSTANCE").addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethods(this.createModuleAddMethod()).addMethods(this.createModuleRemoveMethod()).build();
        try {
            JavaFile javaFile = JavaFile.builder((String)this.packageName, (TypeSpec)moduleFactory).build();
            javaFile.writeTo(this.mFiler);
        }
        catch (FilerException filerException) {
            // empty catch block
        }
    }

    private ArrayList<MethodSpec> createModuleAddMethod() {
        ArrayList<CodeBlock.Builder> list = new ArrayList<CodeBlock.Builder>();
        for (int i = 0; i < name.size(); ++i) {
            list.add(CodeBlock.builder());
        }
        for (String key : this.moduleMaps.keySet()) {
            ModuleInfo info = this.moduleMaps.get(key);
            block11: for (int model : info.model) {
                switch (model) {
                    case 1: {
                        ((CodeBlock.Builder)list.get(0)).addStatement("moduleMap.add($S)", new Object[]{info.getFullClassName()});
                        continue block11;
                    }
                    case 3: {
                        ((CodeBlock.Builder)list.get(1)).addStatement("moduleMap.add($S)", new Object[]{info.getFullClassName()});
                        continue block11;
                    }
                    case 5: {
                        ((CodeBlock.Builder)list.get(2)).addStatement("moduleMap.add($S)", new Object[]{info.getFullClassName()});
                        continue block11;
                    }
                    case 6: {
                        ((CodeBlock.Builder)list.get(3)).addStatement("moduleMap.add($S)", new Object[]{info.getFullClassName()});
                        continue block11;
                    }
                    case 2: {
                        ((CodeBlock.Builder)list.get(4)).addStatement("moduleMap.add($S)", new Object[]{info.getFullClassName()});
                        continue block11;
                    }
                    case 4: {
                        ((CodeBlock.Builder)list.get(5)).addStatement("moduleMap.add($S)", new Object[]{info.getFullClassName()});
                        continue block11;
                    }
                    case 7: {
                        ((CodeBlock.Builder)list.get(6)).addStatement("moduleMap.add($S)", new Object[]{info.getFullClassName()});
                        continue block11;
                    }
                }
            }
        }
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        for (int i = 0; i < name.size(); ++i) {
            methods.add(MethodSpec.methodBuilder((String)("add" + name.get(i))).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("$T<String> moduleMap = new $T<>()", new Object[]{List.class, ArrayList.class}).addCode(((CodeBlock.Builder)list.get(i)).build()).returns((TypeName)ParameterizedTypeName.get(List.class, (Type[])new Type[]{String.class})).addCode("return moduleMap;", new Object[0]).build());
        }
        return methods;
    }

    private ArrayList<MethodSpec> createModuleRemoveMethod() {
        ArrayList<CodeBlock.Builder> list = new ArrayList<CodeBlock.Builder>();
        for (int i = 0; i < name.size(); ++i) {
            list.add(CodeBlock.builder());
        }
        for (String key : this.moduleMaps.keySet()) {
            ModuleInfo info = this.moduleMaps.get(key);
            block11: for (int model : info.unmodel) {
                switch (model) {
                    case 1: {
                        ((CodeBlock.Builder)list.get(0)).addStatement("moduleMap.add($S)", new Object[]{info.getFullClassName()});
                        continue block11;
                    }
                    case 3: {
                        ((CodeBlock.Builder)list.get(1)).addStatement("moduleMap.add($S)", new Object[]{info.getFullClassName()});
                        continue block11;
                    }
                    case 5: {
                        ((CodeBlock.Builder)list.get(2)).addStatement("moduleMap.add($S)", new Object[]{info.getFullClassName()});
                        continue block11;
                    }
                    case 6: {
                        ((CodeBlock.Builder)list.get(3)).addStatement("moduleMap.add($S)", new Object[]{info.getFullClassName()});
                        continue block11;
                    }
                    case 2: {
                        ((CodeBlock.Builder)list.get(4)).addStatement("moduleMap.add($S)", new Object[]{info.getFullClassName()});
                        continue block11;
                    }
                    case 4: {
                        ((CodeBlock.Builder)list.get(5)).addStatement("moduleMap.add($S)", new Object[]{info.getFullClassName()});
                        continue block11;
                    }
                    case 7: {
                        ((CodeBlock.Builder)list.get(6)).addStatement("moduleMap.add($S)", new Object[]{info.getFullClassName()});
                        continue block11;
                    }
                }
            }
        }
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        for (int i = 0; i < name.size(); ++i) {
            methods.add(MethodSpec.methodBuilder((String)("remove" + name.get(i))).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("$T<String> moduleMap = new $T<>()", new Object[]{List.class, ArrayList.class}).addCode(((CodeBlock.Builder)list.get(i)).build()).returns((TypeName)ParameterizedTypeName.get(List.class, (Type[])new Type[]{String.class})).addCode("return moduleMap;", new Object[0]).build());
        }
        return methods;
    }

    private void createModuleConstant() throws IOException {
        TypeSpec.Builder moduleConstant = TypeSpec.classBuilder((String)"Pk$$ModuleConstant").addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (String key : this.moduleMaps.keySet()) {
            ModuleInfo info = this.moduleMaps.get(key);
            moduleConstant.addField(FieldSpec.builder(String.class, (String)info.className, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{info.getFullClassName()}).build());
        }
        try {
            JavaFile javaFile = JavaFile.builder((String)this.packageName, (TypeSpec)moduleConstant.build()).build();
            javaFile.writeTo(this.mFiler);
        }
        catch (FilerException filerException) {
            // empty catch block
        }
    }

    static {
        name.add("NorModule");
        name.add("MvpModule");
        name.add("RankVersion1Module");
        name.add("RankVersion2Module");
        name.add("NewModule");
        name.add("RevengeModule");
        name.add("OppoModule");
    }
}

