/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.mobile.channelpk;

import com.duowan.mobile.channelpk.PKModuleConfig;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public class ModuleInfo {
    public String packageName;
    public String className;
    public int[] model;
    public int[] unmodel;

    public ModuleInfo(Elements elementUtils, TypeElement typeElement) {
        this.packageName = this.getPackageName(elementUtils, typeElement);
        this.className = this.getClassName(typeElement, this.packageName);
        this.model = typeElement.getAnnotation(PKModuleConfig.class).mount();
        this.unmodel = typeElement.getAnnotation(PKModuleConfig.class).unmount();
    }

    public String getClassName(TypeElement type, String packageName) {
        int packageLen = packageName.length() + 1;
        return type.getQualifiedName().toString().substring(packageLen).replace('.', '$');
    }

    public String getPackageName(Elements elementUtils, TypeElement classElement) {
        PackageElement packageElement = elementUtils.getPackageOf(classElement);
        return packageElement.getQualifiedName().toString();
    }

    public String getFullClassName() {
        return this.packageName + "." + this.className;
    }
}

