/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.mobile.channelpk;

import com.duowan.mobile.channelpk.ModuleInfo;
import com.duowan.mobile.channelpk.PKModuleConfig;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

public class ModuleProcessor
extends AbstractProcessor {
    private Map<String, ModuleInfo> moduleMaps = new HashMap<String, ModuleInfo>();
    private Filer mFiler;
    private Elements mElementUtils;
    private Messager mMessager;
    static List<String> name = new ArrayList<String>();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.mFiler = processingEnv.getFiler();
        this.mElementUtils = processingEnv.getElementUtils();
        this.mMessager = processingEnv.getMessager();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        types.add(PKModuleConfig.class.getCanonicalName());
        return types;
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnv) {
        try {
            this.initModuleMap(roundEnv);
            this.createModuleMap();
            this.createModuleConstant();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private void initModuleMap(RoundEnvironment roundEnv) {
        Set<? extends Element> set = roundEnv.getElementsAnnotatedWith(PKModuleConfig.class);
        for (Element element : set) {
            if (element.getKind() == ElementKind.CLASS) {
                String clzName = element.getSimpleName().toString();
                if (this.moduleMaps.get(clzName) != null) continue;
                ModuleInfo info = new ModuleInfo(this.mElementUtils, (TypeElement)element);
                this.moduleMaps.put(clzName, info);
                continue;
            }
            this.mMessager.printMessage(Diagnostic.Kind.NOTE, "only support class");
        }
    }

    private void createModuleMap() throws IOException {
        TypeSpec moduleFactory = TypeSpec.enumBuilder((String)"ModuleFactory").addEnumConstant("INSTANCE").addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethods(this.createModuleAddMethod()).addMethods(this.createModuleRemoveMethod()).build();
        JavaFile javaFile = JavaFile.builder((String)"com.duowan.mobile.channelpk", (TypeSpec)moduleFactory).build();
        javaFile.writeTo(this.mFiler);
    }

    private ArrayList<MethodSpec> createModuleAddMethod() {
        ArrayList<CodeBlock.Builder> list = new ArrayList<CodeBlock.Builder>();
        for (int i = 0; i < name.size(); ++i) {
            list.add(CodeBlock.builder());
        }
        for (String key : this.moduleMaps.keySet()) {
            ModuleInfo info = this.moduleMaps.get(key);
            block10: for (int model : info.model) {
                switch (model) {
                    case 1: {
                        ((CodeBlock.Builder)list.get(0)).addStatement("moduleMap.add($S)", new Object[]{info.getFullClassName()});
                        continue block10;
                    }
                    case 3: {
                        ((CodeBlock.Builder)list.get(1)).addStatement("moduleMap.add($S)", new Object[]{info.getFullClassName()});
                        continue block10;
                    }
                    case 5: {
                        ((CodeBlock.Builder)list.get(2)).addStatement("moduleMap.add($S)", new Object[]{info.getFullClassName()});
                        continue block10;
                    }
                    case 6: {
                        ((CodeBlock.Builder)list.get(3)).addStatement("moduleMap.add($S)", new Object[]{info.getFullClassName()});
                        continue block10;
                    }
                    case 2: {
                        ((CodeBlock.Builder)list.get(4)).addStatement("moduleMap.add($S)", new Object[]{info.getFullClassName()});
                        continue block10;
                    }
                    case 4: {
                        ((CodeBlock.Builder)list.get(5)).addStatement("moduleMap.add($S)", new Object[]{info.getFullClassName()});
                        continue block10;
                    }
                }
            }
        }
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        for (int i = 0; i < name.size(); ++i) {
            methods.add(MethodSpec.methodBuilder((String)("add" + name.get(i))).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("$T<String> moduleMap = new $T<>()", new Object[]{List.class, ArrayList.class}).addCode(((CodeBlock.Builder)list.get(i)).build()).returns((TypeName)ParameterizedTypeName.get(List.class, (Type[])new Type[]{String.class})).addCode("return moduleMap;", new Object[0]).build());
        }
        return methods;
    }

    private ArrayList<MethodSpec> createModuleRemoveMethod() {
        ArrayList<CodeBlock.Builder> list = new ArrayList<CodeBlock.Builder>();
        for (int i = 0; i < name.size(); ++i) {
            list.add(CodeBlock.builder());
        }
        for (String key : this.moduleMaps.keySet()) {
            ModuleInfo info = this.moduleMaps.get(key);
            block10: for (int model : info.unmodel) {
                switch (model) {
                    case 1: {
                        ((CodeBlock.Builder)list.get(0)).addStatement("moduleMap.add($S)", new Object[]{info.getFullClassName()});
                        continue block10;
                    }
                    case 3: {
                        ((CodeBlock.Builder)list.get(1)).addStatement("moduleMap.add($S)", new Object[]{info.getFullClassName()});
                        continue block10;
                    }
                    case 5: {
                        ((CodeBlock.Builder)list.get(2)).addStatement("moduleMap.add($S)", new Object[]{info.getFullClassName()});
                        continue block10;
                    }
                    case 6: {
                        ((CodeBlock.Builder)list.get(3)).addStatement("moduleMap.add($S)", new Object[]{info.getFullClassName()});
                        continue block10;
                    }
                    case 2: {
                        ((CodeBlock.Builder)list.get(4)).addStatement("moduleMap.add($S)", new Object[]{info.getFullClassName()});
                        continue block10;
                    }
                    case 4: {
                        ((CodeBlock.Builder)list.get(5)).addStatement("moduleMap.add($S)", new Object[]{info.getFullClassName()});
                        continue block10;
                    }
                }
            }
        }
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        for (int i = 0; i < name.size(); ++i) {
            methods.add(MethodSpec.methodBuilder((String)("remove" + name.get(i))).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("$T<String> moduleMap = new $T<>()", new Object[]{List.class, ArrayList.class}).addCode(((CodeBlock.Builder)list.get(i)).build()).returns((TypeName)ParameterizedTypeName.get(List.class, (Type[])new Type[]{String.class})).addCode("return moduleMap;", new Object[0]).build());
        }
        return methods;
    }

    private void createModuleConstant() throws IOException {
        TypeSpec.Builder moduleConstant = TypeSpec.classBuilder((String)"ModuleConstant").addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (String key : this.moduleMaps.keySet()) {
            ModuleInfo info = this.moduleMaps.get(key);
            moduleConstant.addField(FieldSpec.builder(String.class, (String)info.className, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{info.getFullClassName()}).build());
        }
        JavaFile javaFile = JavaFile.builder((String)"com.duowan.mobile.channelpk", (TypeSpec)moduleConstant.build()).build();
        javaFile.writeTo(this.mFiler);
    }

    static {
        name.add("NorModule");
        name.add("MvpModule");
        name.add("RankVersion1Module");
        name.add("RankVersion2Module");
        name.add("NewModule");
        name.add("RevengeModule");
    }
}

