/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.model.collection;

import android.support.annotation.NonNull;
import com.yy.mobile.model.collection.ImmutableCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class ImmutableSet<E>
extends ImmutableCollection<E>
implements Set<E> {
    private final Set<E> mInnerSet;

    public ImmutableSet(@NonNull Set<E> set) {
        this(set, false);
    }

    public ImmutableSet(@NonNull Set<E> set, boolean doNotCopy) {
        HashSet temp = doNotCopy ? set : new HashSet(set);
        this.mInnerSet = Collections.unmodifiableSet(temp);
    }

    @Override
    @NonNull
    protected Collection<E> getInnerCollection() {
        return this.mInnerSet;
    }
}

