/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.model.collection;

import android.support.annotation.NonNull;
import com.yy.mobile.model.collection.ImmutableCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public final class ImmutableList<E>
extends ImmutableCollection<E>
implements List<E> {
    private final List<E> mInnerList;

    public ImmutableList(@NonNull List<E> list) {
        this(list, false);
    }

    public ImmutableList(@NonNull List<E> list, boolean doNotCopy) {
        ArrayList temp = doNotCopy ? list : new ArrayList(list);
        this.mInnerList = Collections.unmodifiableList(temp);
    }

    @Override
    @NonNull
    protected Collection<E> getInnerCollection() {
        return this.mInnerList;
    }

    @Override
    @Deprecated
    public void add(int location, E object) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean addAll(int location, @NonNull Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E get(int location) {
        return this.mInnerList.get(location);
    }

    @Override
    public int indexOf(Object object) {
        return this.mInnerList.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.mInnerList.lastIndexOf(object);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.mInnerList.listIterator();
    }

    @Override
    @NonNull
    public ListIterator<E> listIterator(int location) {
        return this.mInnerList.listIterator(location);
    }

    @Override
    @Deprecated
    public E remove(int location) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public E set(int location, E object) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public List<E> subList(int start, int end) {
        return this.mInnerList.subList(start, end);
    }
}

