/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.hiido;

import android.util.Log;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.perf.taskexecutor.IYYTaskExecutor;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.taskexecutor.HardwareUtil;
import com.yy.mobile.util.taskexecutor.IQueueTaskExecutor;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import java.util.ArrayList;
import java.util.HashMap;

public class HiidoExecutor
implements IYYTaskExecutor {
    private static final int MAX_CONCURRENCY_TASKS = HardwareUtil.getCpuCoreCount() >= 4 ? 10 : 8;
    private volatile int mCurrentActiveTasks = 0;
    private ArrayList<HiidoRunnable> mRunnablesToPost = new ArrayList();
    private HashMap<Runnable, HiidoRunnable> mRunnables = new HashMap();
    private static final String TAG = "HiidoExecutor";
    static long tSum;

    public void postToMainThread(Runnable task, long delayMillis) {
        YYTaskExecutor.postToMainThread((Runnable)task, (long)delayMillis);
    }

    public void postIdleRunnableToMainThread(Runnable task) {
        YYTaskExecutor.postIdleRunnableToMainThread((Runnable)task);
    }

    public void removeRunnableFromMainThread(Runnable task) {
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)task);
    }

    public boolean isMainThread() {
        return YYTaskExecutor.isMainThread();
    }

    public com.yy.mobile.perf.taskexecutor.IQueueTaskExecutor createAQueueExcuter() {
        return new HiidoQueueTaskExecutor(YYTaskExecutor.createAQueueExcuter());
    }

    public void execute(Runnable task, long delayMillis) {
        this.execute(task, null, delayMillis, 1);
    }

    public void execute(Runnable task, long delayMillis, int priority) {
        this.execute(task, null, delayMillis, priority);
    }

    public void execute(Runnable task, Runnable callbackInMainThread, long delayMillis) {
        this.execute(task, callbackInMainThread, delayMillis, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable task, Runnable callbackInMainThread, long delayMillis, int priority) {
        HiidoRunnable runNow = null;
        if (delayMillis > 0L) {
            runNow = new HiidoRunnable(task);
            HashMap<Runnable, HiidoRunnable> hashMap = this.mRunnables;
            synchronized (hashMap) {
                this.mRunnables.put(task, runNow);
            }
            YYTaskExecutor.execute((Runnable)runNow, (Runnable)callbackInMainThread, (long)delayMillis, (int)priority);
            return;
        }
        ArrayList<HiidoRunnable> arrayList = this.mRunnablesToPost;
        synchronized (arrayList) {
            this.mRunnablesToPost.add(new HiidoRunnable(task, callbackInMainThread, delayMillis, priority));
        }
        this.executeNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(Runnable task) {
        if (task == null) {
            return;
        }
        HiidoRunnable realRunnable = null;
        Cloneable cloneable = this.mRunnables;
        synchronized (cloneable) {
            realRunnable = this.mRunnables.get(task);
            if (realRunnable != null) {
                this.mRunnables.remove(task);
            }
        }
        cloneable = this.mRunnablesToPost;
        synchronized (cloneable) {
            if (this.mRunnablesToPost.size() > 0) {
                for (HiidoRunnable hiidoRunnable : this.mRunnablesToPost) {
                    if (hiidoRunnable == null || hiidoRunnable.mRunnable != task) continue;
                    this.mRunnablesToPost.remove(hiidoRunnable);
                    break;
                }
            }
        }
        if (realRunnable != null) {
            YYTaskExecutor.removeTask((Runnable)realRunnable);
            --this.mCurrentActiveTasks;
            if (this.mCurrentActiveTasks < 0) {
                this.mCurrentActiveTasks = 0;
            }
            this.executeNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeNext() {
        HiidoRunnable runNow = null;
        HiidoExecutor hiidoExecutor = this;
        synchronized (hiidoExecutor) {
            if (this.mCurrentActiveTasks < MAX_CONCURRENCY_TASKS) {
                ArrayList<HiidoRunnable> arrayList = this.mRunnablesToPost;
                synchronized (arrayList) {
                    if (this.mRunnablesToPost.size() > 0) {
                        runNow = this.mRunnablesToPost.remove(0);
                    }
                }
                if (runNow != null) {
                    ++this.mCurrentActiveTasks;
                }
            }
        }
        if (runNow != null) {
            YYTaskExecutor.execute(runNow, (Runnable)runNow.mCallbackInMainThread, (long)runNow.mDelayMillis, (int)runNow.mPriority, (YYTaskExecutor.TaskType)YYTaskExecutor.TaskType.IO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTaskFinished(HiidoRunnable runnable) {
        --this.mCurrentActiveTasks;
        if (runnable != null) {
            HashMap<Runnable, HiidoRunnable> hashMap = this.mRunnables;
            synchronized (hashMap) {
                this.mRunnables.get(runnable.mRunnable);
            }
        }
        this.executeNext();
    }

    private class HiidoRunnable
    implements Runnable {
        public Runnable mRunnable;
        public Runnable mCallbackInMainThread = null;
        public long mDelayMillis = 0L;
        public int mPriority = 1;

        public HiidoRunnable(Runnable runnable) {
            this.mRunnable = runnable;
        }

        public HiidoRunnable(Runnable runnable, Runnable callbackInMainThread, long delayMillis, int priority) {
            this.mRunnable = runnable;
            this.mCallbackInMainThread = callbackInMainThread;
            this.mDelayMillis = delayMillis;
            this.mPriority = priority;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block6: {
                try {
                    long time = System.currentTimeMillis();
                    if (this.mRunnable != null) {
                        this.mRunnable.run();
                    }
                    long interval = System.currentTimeMillis() - time;
                    Log.d((String)HiidoExecutor.TAG, (String)("hiido run time:" + interval + ",tSum:" + (tSum += interval)));
                    HiidoExecutor.this.onTaskFinished(this);
                    if (!BasicConfig.getInstance().isDebuggable() || this.mRunnable == null) break block6;
                    HiidoExecutor hiidoExecutor = HiidoExecutor.this;
                    synchronized (hiidoExecutor) {
                        MLog.info((Object)HiidoExecutor.TAG, (String)(Thread.currentThread().getName() + ":onTaskFinished:" + this.mRunnable + "  RunnablesToPost" + HiidoExecutor.this.mRunnablesToPost.size()), (Object[])new Object[0]);
                    }
                }
                catch (Throwable throwable) {
                    HiidoExecutor.this.onTaskFinished(this);
                    MLog.info((Object)HiidoExecutor.TAG, (String)("onTaskFinished:" + this.mRunnable + " error:" + throwable), (Object[])new Object[0]);
                    throw throwable;
                }
            }
        }
    }

    private static class HiidoQueueTaskExecutor
    implements com.yy.mobile.perf.taskexecutor.IQueueTaskExecutor {
        private IQueueTaskExecutor mExecutor;

        public HiidoQueueTaskExecutor(IQueueTaskExecutor queueTaskExecutor) {
            this.mExecutor = queueTaskExecutor;
        }

        public void execute(Runnable task, long delayMillis) {
            this.mExecutor.execute(task, delayMillis);
        }

        public void execute(Runnable task, long delayMillis, int priority) {
            this.mExecutor.execute(task, delayMillis, priority);
        }

        public void execute(Runnable task, Runnable callbackInMainThread, long delayMillis) {
            this.mExecutor.execute(task, callbackInMainThread, delayMillis);
        }

        public void execute(Runnable task, Runnable callbackInMainThread, long delayMillis, int priority) {
            this.mExecutor.execute(task, callbackInMainThread, delayMillis, priority);
        }

        public void removeTask(Runnable task) {
            this.mExecutor.removeTask(task);
        }
    }
}

