/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.permission;

import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import com.yy.mobile.util.log.MLog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;

public class PermissionPageUtils {
    private static final String TAG = "PermissionPageManager";
    private Context mContext;
    private String packageName = "com.donkor.demo";

    public PermissionPageUtils(Context context) {
        this.mContext = context;
    }

    public void jumpPermissionPage() {
        String name = Build.MANUFACTURER;
        MLog.info((Object)TAG, (String)("jumpPermissionPage --- name : " + name), (Object[])new Object[0]);
        switch (name) {
            case "HUAWEI": {
                this.goHuaWeiMainager();
                break;
            }
            case "vivo": {
                this.goVivoMainager();
                break;
            }
            case "OPPO": {
                this.goOppoMainager();
                break;
            }
            case "Coolpad": {
                this.goCoolpadMainager();
                break;
            }
            case "Meizu": {
                this.goMeizuMainager();
                break;
            }
            case "Xiaomi": {
                this.goXiaoMiMainager();
                break;
            }
            case "samsung": {
                this.goSangXinMainager();
                break;
            }
            case "Sony": {
                this.goSonyMainager();
                break;
            }
            case "LG": {
                this.goLGMainager();
                break;
            }
            default: {
                this.goIntentSetting();
            }
        }
    }

    private void goLGMainager() {
        try {
            Intent intent = new Intent(this.packageName);
            ComponentName comp = new ComponentName("com.android.settings", "com.android.settings.Settings$AccessLockSummaryActivity");
            intent.setComponent(comp);
            this.mContext.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.goIntentSetting();
        }
    }

    private void goSonyMainager() {
        try {
            Intent intent = new Intent(this.packageName);
            ComponentName comp = new ComponentName("com.sonymobile.cta", "com.sonymobile.cta.SomcCTAMainActivity");
            intent.setComponent(comp);
            this.mContext.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.goIntentSetting();
        }
    }

    private void goHuaWeiMainager() {
        try {
            Intent intent = new Intent(this.packageName);
            intent.setFlags(0x10000000);
            ComponentName comp = new ComponentName("com.huawei.systemmanager", "com.huawei.permissionmanager.ui.MainActivity");
            intent.setComponent(comp);
            this.mContext.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.goIntentSetting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getMiuiVersion() {
        String line;
        String propName = "ro.miui.ui.version.name";
        BufferedReader input = null;
        try {
            Process p = Runtime.getRuntime().exec("getprop " + propName);
            input = new BufferedReader(new InputStreamReader(p.getInputStream()), 1024);
            line = input.readLine();
            input.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return line;
    }

    private void goXiaoMiMainager() {
        String rom = PermissionPageUtils.getMiuiVersion();
        MLog.info((Object)TAG, (String)("goMiaoMiMainager --- rom : " + rom), (Object[])new Object[0]);
        Intent intent = new Intent();
        if ("V6".equals(rom) || "V7".equals(rom)) {
            intent.setAction("miui.intent.action.APP_PERM_EDITOR");
            intent.setClassName("com.miui.securitycenter", "com.miui.permcenter.permissions.AppPermissionsEditorActivity");
            intent.putExtra("extra_pkgname", this.packageName);
            this.mContext.startActivity(intent);
        } else if ("V8".equals(rom) || "V9".equals(rom)) {
            intent.setAction("miui.intent.action.APP_PERM_EDITOR");
            intent.setClassName("com.miui.securitycenter", "com.miui.permcenter.permissions.PermissionsEditorActivity");
            intent.putExtra("extra_pkgname", this.packageName);
            this.mContext.startActivity(intent);
        } else {
            this.goIntentSetting();
        }
    }

    private void goMeizuMainager() {
        try {
            Intent intent = new Intent("com.meizu.safe.security.SHOW_APPSEC");
            intent.addCategory("android.intent.category.DEFAULT");
            intent.putExtra("packageName", this.packageName);
            this.mContext.startActivity(intent);
        }
        catch (ActivityNotFoundException localActivityNotFoundException) {
            localActivityNotFoundException.printStackTrace();
            this.goIntentSetting();
        }
    }

    private void goSangXinMainager() {
        this.goIntentSetting();
    }

    private void goIntentSetting() {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        Uri uri = Uri.fromParts((String)"package", (String)this.mContext.getPackageName(), null);
        intent.setData(uri);
        try {
            this.mContext.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void goOppoMainager() {
        this.doStartApplicationWithPackageName("com.coloros.safecenter");
    }

    private void goCoolpadMainager() {
        this.doStartApplicationWithPackageName("com.yulong.android.security:remote");
    }

    private void goVivoMainager() {
        this.doStartApplicationWithPackageName("com.bairenkeji.icaller");
    }

    private void doStartApplicationWithPackageName(String packagename) {
        PackageInfo packageinfo = null;
        try {
            packageinfo = this.mContext.getPackageManager().getPackageInfo(packagename, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        if (packageinfo == null) {
            this.goIntentSetting();
            return;
        }
        Intent resolveIntent = new Intent("android.intent.action.MAIN", null);
        resolveIntent.addCategory("android.intent.category.LAUNCHER");
        resolveIntent.setPackage(packageinfo.packageName);
        List resolveinfoList = this.mContext.getPackageManager().queryIntentActivities(resolveIntent, 0);
        MLog.info((Object)TAG, (String)("resolveinfoList" + resolveinfoList.size()), (Object[])new Object[0]);
        if (!resolveinfoList.isEmpty()) {
            for (int i = 0; i < resolveinfoList.size(); ++i) {
                MLog.info((Object)TAG, (String)(((ResolveInfo)resolveinfoList.get((int)i)).activityInfo.packageName + ((ResolveInfo)resolveinfoList.get((int)i)).activityInfo.name), (Object[])new Object[0]);
            }
            ResolveInfo resolveinfo = (ResolveInfo)resolveinfoList.get(0);
            if (resolveinfo != null) {
                String packageName = resolveinfo.activityInfo.packageName;
                String className = resolveinfo.activityInfo.name;
                Intent intent = new Intent("android.intent.action.MAIN");
                intent.addCategory("android.intent.category.LAUNCHER");
                ComponentName cn = new ComponentName(packageName, className);
                intent.setComponent(cn);
                try {
                    this.mContext.startActivity(intent);
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.goIntentSetting();
    }
}

