/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.model.store;

import android.support.annotation.Nullable;
import android.util.Log;
import com.jakewharton.rxrelay2.PublishRelay;
import com.jakewharton.rxrelay2.Relay;
import com.yy.mobile.model.Action;
import com.yy.mobile.model.Middleware;
import com.yy.mobile.model.Processor;
import com.yy.mobile.model.Reducer;
import com.yy.mobile.model.ReqAction;
import com.yy.mobile.model.StateAction;
import com.yy.mobile.model.StateChangedEventArgs;
import com.yy.mobile.model.StateChangedListener;
import com.yy.mobile.model.StateChangedListener2;
import com.yy.mobile.model.Store;
import com.yy.mobile.model.store.State;
import com.yy.mobile.util.log.MLog;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractStore<TState extends State>
implements Store<TState> {
    private static final String TAG = "AbstractStore";
    private TState mState;
    private List<Reducer<TState, ? extends StateAction>> mReducers = Collections.emptyList();
    private List<Middleware> mMiddlewareList = Collections.emptyList();
    protected final Object mReduceSyncRoot = new Object();
    protected final Object mMiddlewareSyncRoot = new Object();
    private final Relay<StateChangedEventArgs<TState>> mActionRelay = PublishRelay.create();
    private final Consumer<Throwable> mOnError = new Consumer<Throwable>(){

        public void accept(@NonNull Throwable throwable) throws Exception {
            MLog.error((Object)AbstractStore.TAG, (String)"AbstractStore onError", (Throwable)throwable, (Object[])new Object[0]);
        }
    };
    private static final Map<Class, Processor> mProcessorMarket = new ConcurrentHashMap<Class, Processor>();

    @Override
    public TState getState() {
        if (this.mState == null) {
            MLog.error((Object)TAG, (String)"mState is null", (Object[])new Object[0]);
        }
        return this.mState;
    }

    public <TAction extends ReqAction<T>, T, P extends Processor<TAction, T>> void registerProcessor(@android.support.annotation.NonNull P processor) {
        if (mProcessorMarket.get(processor.getActionClass()) != null) {
            throw new RuntimeException("processor " + processor + " has been register, it must just register once.");
        }
        mProcessorMarket.put(processor.getActionClass(), processor);
    }

    public <TAction extends ReqAction<T>, T, P extends Processor<TAction, T>> void unregisterProcessor(@android.support.annotation.NonNull P processor) {
        mProcessorMarket.remove(processor.getActionClass());
    }

    @Override
    public <TAction extends ReqAction<T>, T> Single<T> dispatch(@android.support.annotation.NonNull TAction action) {
        return this.dispatch(action, false);
    }

    @Override
    public <TAction extends ReqAction<T>, T> Single<T> dispatchWithError(@android.support.annotation.NonNull TAction action) {
        return this.dispatch(action, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <TAction extends Action> void dispatch(@NotNull TAction action) {
        Object object = this.mReduceSyncRoot;
        synchronized (object) {
            if (action instanceof StateAction) {
                StateAction stateAction = (StateAction)action;
                TState originalState = this.mState;
                for (Reducer<TState, StateAction> r : this.mReducers) {
                    if (!action.getClass().equals(r.getActionClass())) continue;
                    this.mState = (State)r.reduce(stateAction, this.mState);
                    if (this.mState != null) continue;
                    this.mState = originalState;
                }
                boolean shouldFireStateChangedEvent = originalState != this.mState;
                TState newState = this.mState;
                if (shouldFireStateChangedEvent) {
                    this.mActionRelay.accept(new StateChangedEventArgs<TState>(stateAction, newState));
                }
            } else {
                this.executeMiddleware(action);
            }
        }
    }

    @Override
    public Observable<StateChangedEventArgs<TState>> getObservable() {
        return this.mActionRelay.toSerialized();
    }

    @Override
    public Disposable subscribe(@android.support.annotation.NonNull StateChangedListener<TState> stateChangedListener) {
        return this.subscribe(stateChangedListener, null);
    }

    private <TAction extends ReqAction<T>, T> Single<T> dispatch(@android.support.annotation.NonNull TAction action, boolean withError) {
        Processor processor = mProcessorMarket.get(action.getClass());
        if (processor != null) {
            final Object result = processor.process(action);
            return Single.create((SingleOnSubscribe)new SingleOnSubscribe<T>(){

                public void subscribe(@NonNull SingleEmitter<T> e) throws Exception {
                    e.onSuccess(result);
                }
            });
        }
        if (withError) {
            return Single.error((Throwable)new Throwable(">>>>>>>>>>this action has not reduce or processor to hand<<<<<<<<<<<"));
        }
        return Single.create((SingleOnSubscribe)new SingleOnSubscribe<T>(){

            public void subscribe(@NonNull SingleEmitter<T> e) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <TAction extends Action> void executeMiddleware(final @android.support.annotation.NonNull TAction action) {
        if (this.mMiddlewareList.size() > 0) {
            Object object = this.mMiddlewareSyncRoot;
            synchronized (object) {
                Observable.fromIterable(this.mMiddlewareList).filter((Predicate)new Predicate<Middleware>(){

                    public boolean test(@NonNull Middleware middleware) {
                        return middleware.canHandlerAction(action);
                    }
                }).flatMap((Function)new Function<Middleware, ObservableSource<? extends Action>>(){

                    public ObservableSource<? extends Action> apply(@NonNull Middleware middleware) {
                        return middleware.process(action);
                    }
                }).subscribe((Observer)new Observer<Action>(){

                    public void onSubscribe(Disposable d) {
                    }

                    public void onNext(Action action) {
                        AbstractStore.this.dispatch(action);
                    }

                    public void onError(Throwable e) {
                        Log.e((String)AbstractStore.TAG, (String)"executeMiddleware failed.", (Throwable)e);
                    }

                    public void onComplete() {
                    }
                });
            }
        }
    }

    public Disposable subscribe(final @android.support.annotation.NonNull StateChangedListener<TState> stateChangedListener, @Nullable Consumer<Throwable> onError) {
        StateChangedListener2 listener2;
        List<Class<StateAction>> interestedActionTypes;
        onError = onError == null ? this.mOnError : onError;
        Observable observable = this.mActionRelay;
        if (stateChangedListener instanceof StateChangedListener2 && (interestedActionTypes = (listener2 = (StateChangedListener2)stateChangedListener).getInterestedActionTypes()) != null && interestedActionTypes.size() > 0) {
            observable = observable.filter(new Predicate<StateChangedEventArgs<TState>>(){

                public boolean test(@NonNull StateChangedEventArgs<TState> eventArgs) throws Exception {
                    return interestedActionTypes.contains(eventArgs.action.getClass());
                }
            });
        }
        return observable.subscribe(new Consumer<StateChangedEventArgs<TState>>(){

            public void accept(@NonNull StateChangedEventArgs<TState> eventArgs) throws Exception {
                stateChangedListener.onStateChanged(eventArgs);
            }
        }, onError);
    }

    @SafeVarargs
    public final void init(@android.support.annotation.NonNull TState initState, Reducer<TState, ? extends StateAction> ... reducers) {
        this.init(initState, Collections.emptyList(), Arrays.asList(reducers));
    }

    public final void init(@android.support.annotation.NonNull TState initState, List<Middleware> middlewareList, List<Reducer<TState, ? extends StateAction>> reducers) {
        if (initState == null) {
            throw new NullPointerException("initState is null");
        }
        this.mState = initState;
        this.mMiddlewareList = Collections.unmodifiableList(middlewareList);
        this.mReducers = Collections.unmodifiableList(reducers);
    }

    public abstract void init(List<Middleware> var1);
}

