/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.model.collection;

import android.support.annotation.NonNull;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class ImmutableMap<K, V>
implements Map<K, V> {
    private final Map<K, V> mInnerMap;

    public ImmutableMap(@NonNull Map<K, V> map) {
        this(map, false);
    }

    public ImmutableMap(@NonNull Map<K, V> map, boolean doNotCopy) {
        HashMap temp = doNotCopy ? map : new HashMap(map);
        this.mInnerMap = Collections.unmodifiableMap(temp);
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.mInnerMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.mInnerMap.containsValue(value);
    }

    @Override
    @NonNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.mInnerMap.entrySet();
    }

    @Override
    public V get(Object key) {
        return this.mInnerMap.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.mInnerMap.isEmpty();
    }

    @Override
    @NonNull
    public Set<K> keySet() {
        return this.mInnerMap.keySet();
    }

    @Override
    @Deprecated
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void putAll(@NonNull Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.mInnerMap.size();
    }

    @Override
    @NonNull
    public Collection<V> values() {
        return this.mInnerMap.values();
    }
}

