/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.hiido;

import android.content.Context;
import com.yy.hiidostatis.api.HiidoSDK;
import com.yy.hiidostatis.api.OnStatisListener;
import com.yy.hiidostatis.api.StatisOption;
import com.yy.hiidostatis.defs.listener.ActAdditionListener;
import com.yy.hiidostatis.defs.listener.ActListener;
import com.yy.hiidostatis.inner.util.InsideMode;
import com.yy.mobile.cache.StringDiskCache;
import com.yy.mobile.hiido.HiidoExecutor;
import com.yy.mobile.http.DiskCache;
import com.yy.mobile.perf.taskexecutor.IYYTaskExecutor;
import com.yy.mobile.util.AppMetaDataUtil;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.VersionUtil;
import com.yy.mobile.util.log.MLog;
import java.io.File;
import java.io.IOException;

public class HiidoStatisticHelper {
    public static String STATISTIC_HIIDO_TEST_SERVER = "http://datatest.hiido.com/c.gif";
    public static final String HIIDO_STATISTIC_SETTINGS = "hiido_statistic_settings";

    public static String getHiidoStatisticInputTestServer(Context context, String key) {
        StringDiskCache diskCache = StringDiskCache.openCache((File)DiskCache.getCacheDir((Context)context.getApplicationContext(), (String)("yymobile" + File.separator + HIIDO_STATISTIC_SETTINGS)), (long)1000L);
        String value = null;
        try {
            value = diskCache.getRaw(key);
            MLog.verbose((Object)"HostDiskCacheHelper", (String)("[getHiidoStatisticInputTestServer] key=" + key + " ,value=" + value), (Object[])new Object[0]);
        }
        catch (IOException e) {
            MLog.verbose((Object)"HostDiskCacheHelper", (String)("getHiidoStatisticInputTestServer error = " + e), (Object[])new Object[0]);
        }
        return value;
    }

    public static void initHiidoSdk(Context context, OnStatisListener listener, ActAdditionListener actAdditionListener, String testServer, String from, boolean isOpenCrashMonitor, String hiidoAppKey) {
        try {
            HiidoSDK.Options options = new HiidoSDK.Options();
            if (!StringUtils.isEmpty((String)testServer).booleanValue()) {
                options.behaviorSendThreshold = 0;
                options.testServer = testServer;
            }
            StatisOption sOption = new StatisOption();
            options.isOpenCrashMonitor = isOpenCrashMonitor;
            sOption.setAppId(hiidoAppKey);
            sOption.setAppkey(hiidoAppKey);
            if (!StringUtils.isEmpty((String)from).booleanValue()) {
                sOption.setFrom(from);
            } else {
                sOption.setFrom(AppMetaDataUtil.getChannelID((Context)context));
            }
            sOption.setVer(VersionUtil.getLocalVer((Context)context).getOriginalVersion());
            options.isNewMac = false;
            options.setTaskExecutor((IYYTaskExecutor)new HiidoExecutor());
            HiidoSDK.instance().setOptions(options);
            HiidoSDK.instance().getOptions().setUseOaid(false).setHostApp(InsideMode.HostApp.VIVO);
            if (actAdditionListener != null) {
                HiidoSDK.instance().addActAdditionListener((ActListener)actAdditionListener);
            }
            HiidoSDK.instance().appStartLaunchWithAppKey(context, sOption, listener);
        }
        catch (Throwable ex) {
            MLog.error((Object)"HiidoSDK", (Throwable)ex);
        }
    }
}

