/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.yyanchor.revenue.gift;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.unionyy.mobile.yyanchor.revenue.argift.ArEntity;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.http.ProgressInfo;
import com.yy.mobile.http.ProgressListener;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestManager;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.liveapi.pk.PkScenenConfig;
import com.yy.mobile.pref2.SharedPreferencesUtils;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.FileUtil;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.anchor.Publisher;
import com.yymobile.core.gift.PkArGiftManager;
import com.yymobile.core.mobilelive.MobileLiveFileUtil;
import io.reactivex.Completable;
import io.reactivex.CompletableEmitter;
import io.reactivex.CompletableOnSubscribe;
import io.reactivex.CompletableSource;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class VideoFilterPkArGiftManager
implements PkArGiftManager {
    private static final String PREFERENCE_NAME = "PKARGiftManagerPreferences";
    private static final String PREFERENCE_KEY_RES_MD5_PRE_FIX = "res_md5_";
    private static final String TAG = "PkArGiftManager";
    private static final String NOMEDIA = ".nomedia";
    private Map<PkArGiftManager.PkArType, String> mUnZipFileNames = new HashMap<PkArGiftManager.PkArType, String>();
    private PkArGiftManager.PkArType lastPkArType = PkArGiftManager.PkArType.NONE;
    private Map<String, ArEntity> mJoyPkEffectTagSet;
    private String mBandaidShowUrl1 = "";
    private String mBandaidShowUrl2 = "";
    private String mBandaidShowUrl3 = "";
    private String mMvpUrl100 = "";
    private String mMvpUrl101 = "";
    private String mMvpUrl102 = "";
    private String mMvpUrl103 = "";
    private String crownUrl = "";
    private String chijiUrl = "";
    private String cryUrl = "";
    private String shenyouUrl = "";
    private SharedPreferences mARGiftManagerPreferences = SharedPreferencesUtils.getSharedPreferences((Context)BasicConfig.getInstance().getAppContext(), (String)"PKARGiftManagerPreferences", (int)0);
    private static final File stickerPath = new File(BasicConfig.getInstance().getRootDir().getAbsolutePath() + File.separator + "pkargiftstickers");

    public VideoFilterPkArGiftManager(@NotNull PkScenenConfig config) {
        this.getOrMkDirsStickerPath();
        this.createArGiftDirFileIfNeed();
        this.mBandaidShowUrl1 = config.getUrlBandaid1();
        this.mBandaidShowUrl2 = config.getUrlBandaid2();
        this.mBandaidShowUrl3 = config.getUrlBandaid3();
        this.cryUrl = config.getUrlCry();
        this.crownUrl = config.getUrlCrown();
        this.chijiUrl = config.getUrlChiji();
        this.shenyouUrl = config.getUrlShenyou();
        this.mMvpUrl100 = config.getMVPurl_100();
        this.mMvpUrl101 = config.getMVPurl_101();
        this.mMvpUrl102 = config.getMVPurl_102();
        this.mMvpUrl103 = config.getMVPurl_103();
        this.mJoyPkEffectTagSet = new LinkedHashMap<String, ArEntity>();
    }

    protected File getOrMkDirsStickerPath() {
        if (!stickerPath.exists()) {
            stickerPath.mkdirs();
        }
        return stickerPath;
    }

    protected void showArEffect(String type, ArEntity entity) {
        Publisher.getInstance().getVideoFilter().setJoyPkEffect(entity.getPath().getAbsolutePath(), entity.getGrade(), type);
    }

    protected void removeArEffect(String type, ArEntity entity) {
        Publisher.getInstance().getVideoFilter().removeJoyPkEffectWithTag(type);
    }

    public void showARGiftOnce(PkArGiftManager.PkArType type, int grade) {
        MLog.info((Object)TAG, (String)"showARGiftOnce", (Object[])new Object[0]);
        String arFilePath = this.mUnZipFileNames.get(type);
        if (!TextUtils.isEmpty((CharSequence)arFilePath)) {
            this.showPkArGiftOrSticker(arFilePath, grade, type);
        } else {
            this.downloadARFileAndDCompressIfNeed(type, grade, ShowMode.ONCE);
        }
    }

    public void hideARGiftFade(PkArGiftManager.PkArType type, int grade) {
        MLog.info((Object)TAG, (String)("hideARGiftFade, type:" + type), (Object[])new Object[0]);
        this.clearArEffect(this.lastPkArType);
        String arFilePath = this.mUnZipFileNames.get(type);
        if (!TextUtils.isEmpty((CharSequence)arFilePath)) {
            this.lastPkArType = type;
            this.showPkArGiftOrSticker(arFilePath, grade, type);
        } else {
            this.downloadARFileAndDCompressIfNeed(type, grade, ShowMode.FADE);
        }
    }

    public void showARGiftLongTime(PkArGiftManager.PkArType type, int grade) {
        MLog.info((Object)TAG, (String)("showARGiftLongTime, type:" + type), (Object[])new Object[0]);
        if (this.lastPkArType.equals((Object)type)) {
            return;
        }
        this.clearArEffect(this.lastPkArType);
        this.removeInaccuracyStickerFileCache(type, this.mUnZipFileNames.get(type));
        String arFilePath = this.mUnZipFileNames.get(type);
        if (!TextUtils.isEmpty((CharSequence)arFilePath)) {
            this.showPkArGiftOrSticker(arFilePath, grade, type);
            this.lastPkArType = type;
        } else {
            this.downloadARFileAndDCompressIfNeed(type, grade, ShowMode.LONG);
        }
    }

    private void removeInaccuracyStickerFileCache(PkArGiftManager.PkArType type, String unzipResourcePath) {
        if (type == null || TextUtils.isEmpty((CharSequence)unzipResourcePath)) {
            return;
        }
        String verifyMd5 = this.getPreferenceResourceMd5(unzipResourcePath);
        String cacheMd5 = this.cacheMd5(unzipResourcePath);
        if (TextUtils.isEmpty((CharSequence)verifyMd5) || !verifyMd5.equals(cacheMd5)) {
            FileUtil.delete((String)unzipResourcePath);
            this.mUnZipFileNames.remove(type);
        }
    }

    public void clearAllArGift() {
        MLog.info((Object)TAG, (String)"clearAllArGift", (Object[])new Object[0]);
        for (Map.Entry<String, ArEntity> keyValue : this.mJoyPkEffectTagSet.entrySet()) {
            this.removeArEffect(keyValue.getKey(), keyValue.getValue());
        }
        this.mJoyPkEffectTagSet.clear();
        this.lastPkArType = PkArGiftManager.PkArType.NONE;
    }

    public void clearArEffect(PkArGiftManager.PkArType type) {
        if (this.mJoyPkEffectTagSet == null) {
            return;
        }
        MLog.info((Object)TAG, (String)"clearArEffect", (Object[])new Object[0]);
        String key = type.toString();
        ArEntity entity = this.mJoyPkEffectTagSet.remove(key);
        this.removeArEffect(key, entity);
    }

    private void showPkArGiftOrSticker(String unzipedFileDirName, int grade, PkArGiftManager.PkArType type) {
        MLog.info((Object)TAG, (String)("showPkArGiftOrSticker, type:" + type), (Object[])new Object[0]);
        ArrayList<String> effectNames = this.getAREffectName(unzipedFileDirName);
        File resDir = new File(unzipedFileDirName);
        File path = null;
        if (effectNames.size() == 0) {
            MLog.info((Object)TAG, (String)(unzipedFileDirName + " ,there is no .ofeffect exist!"), (Object[])new Object[0]);
        } else if (effectNames.size() == 1) {
            MLog.info((Object)TAG, (String)(unzipedFileDirName + " ,this is VR_GIFT dir"), (Object[])new Object[0]);
            path = effectNames.get(0) == null ? null : new File(resDir, effectNames.get(0));
        } else if (effectNames.size() == 2) {
            MLog.info((Object)TAG, (String)(unzipedFileDirName + " ,this is vr STICKER dir"), (Object[])new Object[0]);
            if (type.equals((Object)PkArGiftManager.PkArType.BANDAID_FADE_1) || type.equals((Object)PkArGiftManager.PkArType.BANDAID_FADE_2) || type.equals((Object)PkArGiftManager.PkArType.BANDAID_FADE_3) || type.equals((Object)PkArGiftManager.PkArType.MVP_FADE_0) || type.equals((Object)PkArGiftManager.PkArType.MVP_FADE_1) || type.equals((Object)PkArGiftManager.PkArType.MVP_FADE_2) || type.equals((Object)PkArGiftManager.PkArType.MVP_FADE_3) || type.equals((Object)PkArGiftManager.PkArType.CHIJI_FADE)) {
                path = effectNames.get(0) == null ? null : new File(resDir, "effect2.ofeffect");
            } else if (type.equals((Object)PkArGiftManager.PkArType.BANDAID_SHOW_1) || type.equals((Object)PkArGiftManager.PkArType.BANDAID_SHOW_2) || type.equals((Object)PkArGiftManager.PkArType.BANDAID_SHOW_3) || type.equals((Object)PkArGiftManager.PkArType.MVP_SHOW_0) || type.equals((Object)PkArGiftManager.PkArType.MVP_SHOW_1) || type.equals((Object)PkArGiftManager.PkArType.MVP_SHOW_2) || type.equals((Object)PkArGiftManager.PkArType.MVP_SHOW_3) || type.equals((Object)PkArGiftManager.PkArType.CHIJI_SHOW)) {
                File file = path = effectNames.get(0) == null ? null : new File(resDir, "effect1.ofeffect");
            }
        }
        if (path != null) {
            ArEntity entity = new ArEntity(path, resDir, grade);
            this.mJoyPkEffectTagSet.put(type.toString(), entity);
            this.showArEffect(type.toString(), entity);
        }
    }

    private void createArGiftDirFileIfNeed() {
        File file = new File(this.getOrMkDirsStickerPath(), NOMEDIA);
        MLog.info((Object)TAG, (String)("Face checkPathAndNoMedia path " + file.getAbsolutePath() + " exsit =" + file.exists()), (Object[])new Object[0]);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                MLog.info((Object)TAG, (String)("Face checkPathAndNoMedia error  " + e.toString()), (Object[])new Object[0]);
            }
        }
    }

    private void downloadARFileAndDCompressIfNeed(final PkArGiftManager.PkArType type, final int grade, final ShowMode showMode) {
        MLog.info((Object)TAG, (String)("downloadARFileAndDCompressIfNeed, type:" + type), (Object[])new Object[0]);
        String url = "";
        switch (type) {
            case BANDAID_SHOW_1: {
                url = this.mBandaidShowUrl1;
                break;
            }
            case BANDAID_FADE_1: {
                url = this.mBandaidShowUrl1;
                break;
            }
            case BANDAID_SHOW_2: {
                url = this.mBandaidShowUrl2;
                break;
            }
            case BANDAID_FADE_2: {
                url = this.mBandaidShowUrl2;
                break;
            }
            case BANDAID_SHOW_3: {
                url = this.mBandaidShowUrl3;
                break;
            }
            case BANDAID_FADE_3: {
                url = this.mBandaidShowUrl3;
                break;
            }
            case MVP_SHOW_0: 
            case MVP_FADE_0: {
                url = this.mMvpUrl100;
                break;
            }
            case MVP_SHOW_1: 
            case MVP_FADE_1: {
                url = this.mMvpUrl101;
                break;
            }
            case MVP_SHOW_2: 
            case MVP_FADE_2: {
                url = this.mMvpUrl102;
                break;
            }
            case MVP_SHOW_3: 
            case MVP_FADE_3: {
                url = this.mMvpUrl103;
                break;
            }
            case CROWN: {
                url = this.crownUrl;
                break;
            }
            case CHIJI_SHOW: 
            case CHIJI_FADE: {
                url = this.chijiUrl;
                break;
            }
            case CRY: {
                url = this.cryUrl;
                break;
            }
            case SHENYOU: {
                url = this.shenyouUrl;
                break;
            }
            default: {
                return;
            }
        }
        MLog.info((Object)TAG, (String)("downloadpkarFile " + url + " type " + type), (Object[])new Object[0]);
        String filePathFromUrl = this.getZipFileNameByUrl(url);
        if (filePathFromUrl.equals("")) {
            MLog.info((Object)TAG, (String)"get filepath from url failed, stop download!!!", (Object[])new Object[0]);
            return;
        }
        File file = new File(this.getOrMkDirsStickerPath(), filePathFromUrl);
        final String filePath = file.getAbsolutePath();
        if (!file.exists()) {
            MLog.info((Object)TAG, (String)("download zip file path:" + filePath), (Object[])new Object[0]);
            RequestManager.instance().submitDownloadRequest(url, filePath, (ResponseListener)new ResponseListener<String>(){

                public void onResponse(String response) {
                    MLog.info((Object)VideoFilterPkArGiftManager.TAG, (String)("download success: " + response), (Object[])new Object[0]);
                    VideoFilterPkArGiftManager.this.decompressStickInfo(filePath, type, grade, showMode);
                }
            }, new ResponseErrorListener(){

                public void onErrorResponse(RequestError error) {
                    MLog.error((Object)VideoFilterPkArGiftManager.TAG, (String)"download error", (Object[])new Object[0]);
                }
            }, new ProgressListener(){

                public void onProgress(ProgressInfo info) {
                }
            }, false, false);
        } else {
            MLog.info((Object)TAG, (String)("file excist ,unzip file path:" + filePath), (Object[])new Object[0]);
            this.decompressStickInfo(filePath, type, grade, showMode);
        }
    }

    @SuppressLint(value={"CheckResult"})
    private void decompressStickInfo(final String zipFilePath, final PkArGiftManager.PkArType type, final int grade, final ShowMode showMode) {
        final AtomicBoolean isDecompressed = new AtomicBoolean(false);
        Completable.create((CompletableOnSubscribe)new CompletableOnSubscribe(){

            public void subscribe(CompletableEmitter emitter) throws Exception {
                VideoFilterPkArGiftManager.this.decompressFile(zipFilePath, type, grade, showMode);
                MLog.info((Object)VideoFilterPkArGiftManager.TAG, (String)"decompressStickInfo end decompress", (Object[])new Object[0]);
                isDecompressed.set(true);
                emitter.onComplete();
            }
        }).subscribeOn(Schedulers.newThread()).observeOn(Schedulers.io()).timeout(10L, TimeUnit.SECONDS).onErrorResumeNext((Function)new Function<Throwable, CompletableSource>(){

            public CompletableSource apply(final Throwable throwable) throws Exception {
                return Completable.create((CompletableOnSubscribe)new CompletableOnSubscribe(){

                    public void subscribe(CompletableEmitter emitter) throws Exception {
                        MLog.error((Object)VideoFilterPkArGiftManager.TAG, (String)"redownload: ", (Throwable)throwable, (Object[])new Object[0]);
                        VideoFilterPkArGiftManager.this.downloadARFileAndDCompressIfNeed(type, grade, showMode);
                        emitter.onComplete();
                    }
                });
            }
        }).subscribe(new Action(){

            public void run() throws Exception {
                MLog.info((Object)VideoFilterPkArGiftManager.TAG, (String)"decompressStickInfo success", (Object[])new Object[0]);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                MLog.error((Object)VideoFilterPkArGiftManager.TAG, (String)("decompressStickInfo error:" + throwable.getMessage()), (Object[])new Object[0]);
            }
        });
    }

    private void decompressFile(String zipFilePath, PkArGiftManager.PkArType type, int grade, ShowMode showMode) throws IOException {
        MLog.info((Object)TAG, (String)"decompressFile", (Object[])new Object[0]);
        String unzipPath = this.getUnzipResourceDirPath(this.decompressGetZipFileNameByUrl(zipFilePath));
        File zipFile = new File(zipFilePath);
        if (zipFile.exists()) {
            FileUtil.unzip((File)zipFile, (String)unzipPath, (String)"");
            this.mUnZipFileNames.put(type, unzipPath);
            String resourceMd5 = this.cacheMd5(unzipPath);
            this.setPreferenceResourceMd5(unzipPath, resourceMd5);
            MLog.info((Object)TAG, (String)("decompress done. md5=" + resourceMd5), (Object[])new Object[0]);
            if (showMode.equals((Object)ShowMode.ONCE)) {
                this.showARGiftOnce(type, grade);
            } else if (showMode.equals((Object)ShowMode.LONG)) {
                this.showARGiftLongTime(type, grade);
            } else if (showMode.equals((Object)ShowMode.FADE)) {
                this.hideARGiftFade(type, grade);
            }
        } else {
            throw new RuntimeException("zip file not exist");
        }
        MLog.info((Object)TAG, (String)"ar pk gift decompress success", (Object[])new Object[0]);
    }

    private String getUnzipResourceDirPath(String zipFileName) {
        File f = new File(this.getOrMkDirsStickerPath(), zipFileName + "_res");
        return f.getAbsolutePath();
    }

    private ArrayList<String> getAREffectName(String unzipFileDirName) {
        ArrayList<String> effectFiles = new ArrayList<String>();
        File file = new File(unzipFileDirName);
        File[] files = file.listFiles(new AREffectFilter());
        if (files != null) {
            for (File effectFile : files) {
                effectFiles.add(effectFile.getName());
            }
        }
        return effectFiles;
    }

    private String getZipFileNameByUrl(String url) {
        int index = url.lastIndexOf("/");
        String filePath = url.substring(index + 1, url.length());
        return filePath;
    }

    private String decompressGetZipFileNameByUrl(String url) {
        int index = url.lastIndexOf("/");
        String filePath = url.substring(index + 1, url.length());
        if (filePath.endsWith(".zip")) {
            MLog.info((Object)TAG, (String)"getZipFileNameByUrl: need to evit zip suffix", (Object[])new Object[0]);
            filePath = filePath.replace(".zip", "");
        }
        return filePath;
    }

    private String cacheMd5(String upzipResourcePath) {
        Object[] resourceFiles = new File(upzipResourcePath).listFiles();
        if (FP.empty((Object[])resourceFiles)) {
            return "";
        }
        return MobileLiveFileUtil.filesMd5((File[])resourceFiles);
    }

    private String getPreferenceResourceMd5Key(String unzipResourcePath) {
        if (TextUtils.isEmpty((CharSequence)unzipResourcePath)) {
            return "";
        }
        return PREFERENCE_KEY_RES_MD5_PRE_FIX + unzipResourcePath;
    }

    private String getPreferenceResourceMd5(String unzipResourcePath) {
        if (TextUtils.isEmpty((CharSequence)unzipResourcePath)) {
            return "";
        }
        return this.mARGiftManagerPreferences.getString(this.getPreferenceResourceMd5Key(unzipResourcePath), "");
    }

    private void setPreferenceResourceMd5(String unzipResourcePath, String md5) {
        if (TextUtils.isEmpty((CharSequence)unzipResourcePath)) {
            return;
        }
        this.mARGiftManagerPreferences.edit().putString(this.getPreferenceResourceMd5Key(unzipResourcePath), md5).apply();
    }

    static class AREffectFilter
    implements FileFilter {
        AREffectFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName();
            return name.endsWith(".ofeffect");
        }
    }

    private static enum ShowMode {
        ONCE,
        LONG,
        FADE;

    }
}

