/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.yyanchor.revenue.gift;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.unionyy.mobile.yyanchor.R;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yymobile.core.gift.GiftConfigItemBase;
import com.yymobile.core.gift.GiftConfigParser;
import com.yymobile.core.gift.GiftContainer;

public class HostGiftView
extends LinearLayout {
    private TextView name;
    private TextView count;
    private RecycleImageView giftImage;
    private TextView firstSendTips;

    public HostGiftView(Context context) {
        super(context);
        this.initialize();
    }

    public HostGiftView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize();
    }

    private void initialize() {
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        View view = inflater.inflate(R.layout.yyanchor_host_kn_gift_animation_view, (ViewGroup)this);
        this.name = (TextView)view.findViewById(R.id.from_person);
        this.count = (TextView)view.findViewById(R.id.gift_count);
        this.giftImage = (RecycleImageView)view.findViewById(R.id.gift_image);
        this.firstSendTips = (TextView)view.findViewById(R.id.first_send_tips);
    }

    @SuppressLint(value={"SetTextI18n"})
    public void updateInfo(GiftContainer.GiftItem info) {
        this.name.setText((CharSequence)info.fromName);
        this.count.setText((CharSequence)("x" + info.num));
        ImageLoader.loadImage((String)GiftConfigParser.getInstance().getGiftIconPath(info.type), (RecycleImageView)this.giftImage, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.lr_ic_default_gift);
        this.firstSendTips.setVisibility(8);
        GiftConfigItemBase item = GiftConfigParser.getInstance().getGiftConfigItemByType(info.type);
        if (item instanceof GiftConfigParser.FreeGiftConfigItem && ((GiftConfigParser.FreeGiftConfigItem)item).business == GiftConfigParser.FreeGiftConfigItem.Business.first_send) {
            this.firstSendTips.setVisibility(0);
        }
    }
}

