/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.yyanchor.login.phonenum;

import android.graphics.Color;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.text.method.HideReturnsTransformationMethod;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import com.unionyy.mobile.magnet.core.login.AuthCallback;
import com.unionyy.mobile.magnet.southpole.Magnet;
import com.unionyy.mobile.yyanchor.R;
import com.unionyy.mobile.yyanchor.login.phonenum.SetPasswordActivity$$EventBinder;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.android.arouter.facade.annotation.Autowired;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.plugin.main.events.IAuthClient_onLoginSucceed_EventArgs;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.util.PasswordUtil;
import com.yy.mobile.util.log.MLog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetPasswordActivity
extends BaseActivity {
    private static final String TAG = "SetPasswordActivity";
    private static final int ASIIC_MAX_VALUE = 128;
    private SimpleTitleBar mTitleBar;
    private EditText mInputPassword;
    private RecycleImageView mVisibleIcon;
    private TextView mConfirmBtn;
    private boolean isPasswordVisible = false;
    private InputMethodManager manager;
    @Autowired(name="user")
    String mMobilePhone;
    @Autowired(name="smsCode")
    String mSmsCode;
    private EventBinder mSetPasswordActivitySniperEventBinder;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        MLog.info((Object)TAG, (String)"SetPasswordActivity onCreate", (Object[])new Object[0]);
        this.setContentView(R.layout.layout_set_password_activity);
        this.mTitleBar = (SimpleTitleBar)this.findViewById(R.id.set_password_title_bar);
        this.mInputPassword = (EditText)this.findViewById(R.id.set_password_edit_text);
        this.mVisibleIcon = (RecycleImageView)this.findViewById(R.id.set_password_is_visible);
        this.mConfirmBtn = (TextView)this.findViewById(R.id.set_password_confirm_btn);
        this.manager = (InputMethodManager)this.getSystemService("input_method");
        this.mTitleBar.setTitlte("\u8bbe\u7f6e\u5bc6\u7801");
        this.mTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                SetPasswordActivity.this.finish();
            }
        });
        this.mVisibleIcon.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (SetPasswordActivity.this.isPasswordVisible) {
                    SetPasswordActivity.this.mVisibleIcon.setImageResource(R.drawable.icon_invisible);
                    SetPasswordActivity.this.isPasswordVisible = false;
                    SetPasswordActivity.this.mInputPassword.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
                    SetPasswordActivity.this.mInputPassword.setSelection(SetPasswordActivity.this.mInputPassword.getText().toString().length());
                } else {
                    SetPasswordActivity.this.mVisibleIcon.setImageResource(R.drawable.icon_visible);
                    SetPasswordActivity.this.isPasswordVisible = true;
                    SetPasswordActivity.this.mInputPassword.setTransformationMethod((TransformationMethod)HideReturnsTransformationMethod.getInstance());
                    SetPasswordActivity.this.mInputPassword.setSelection(SetPasswordActivity.this.mInputPassword.getText().toString().length());
                }
            }
        });
        this.mInputPassword.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                SetPasswordActivity.this.changeComfirmButtonState(s);
            }
        });
        this.mConfirmBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MLog.info((Object)SetPasswordActivity.TAG, (String)"SetPasswordActivity mConfirmBtn clicked", (Object[])new Object[0]);
                if (SetPasswordActivity.this.checkNetToast()) {
                    String password = SetPasswordActivity.this.mInputPassword.getText().toString();
                    Magnet.INSTANCE.smsCodeLogin(SetPasswordActivity.this.mMobilePhone, SetPasswordActivity.this.mSmsCode, password, new AuthCallback(){

                        public void onSuccess(long uid, @NotNull String ticket, boolean isNewUser) {
                        }

                        public void onFail(@Nullable String s) {
                        }
                    });
                }
            }
        });
        this.mConfirmBtn.setClickable(false);
        Object var3_2 = null;
        if (this.mSetPasswordActivitySniperEventBinder == null) {
            this.mSetPasswordActivitySniperEventBinder = new SetPasswordActivity$$EventBinder();
        }
        this.mSetPasswordActivitySniperEventBinder.bindEvent((Object)this);
    }

    private void changeComfirmButtonState(Editable s) {
        if (this.checkPasswordLegal(s)) {
            this.mConfirmBtn.setTextColor(-16777216);
            this.mConfirmBtn.setBackgroundResource(R.drawable.bg_preview_btn_selector);
            this.mConfirmBtn.setClickable(true);
        } else {
            this.mConfirmBtn.setTextColor(Color.parseColor((String)"#BBBBBB"));
            this.mConfirmBtn.setBackgroundResource(R.drawable.btn_white_press);
            this.mConfirmBtn.setClickable(false);
        }
    }

    private boolean checkPasswordLegal(Editable s) {
        if (this.containInvalidChar(s.toString())) {
            return false;
        }
        if (s.length() < 8) {
            return false;
        }
        if (s.length() == 8) {
            return !PasswordUtil.isOnlyDigit((CharSequence)s.toString());
        }
        return s.length() > 8 && s.length() <= 20;
    }

    private boolean containInvalidChar(String password) {
        boolean ret = false;
        int len = password.length();
        for (int i = 0; i < len; ++i) {
            char c = password.charAt(i);
            if (c <= '\u0080') continue;
            ret = true;
            break;
        }
        return ret;
    }

    @BusEvent
    public void onLoginSucceed(IAuthClient_onLoginSucceed_EventArgs busEventArgs) {
        long userId = busEventArgs.getUid();
        MLog.info((Object)TAG, (String)("onLoginSucceed, userId : " + userId), (Object[])new Object[0]);
        this.finish();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 0 && this.getCurrentFocus() != null && this.getCurrentFocus().getWindowToken() != null) {
            this.manager.hideSoftInputFromWindow(this.getCurrentFocus().getWindowToken(), 2);
        }
        return super.onTouchEvent(event);
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mSetPasswordActivitySniperEventBinder != null) {
            this.mSetPasswordActivitySniperEventBinder.unBindEvent();
        }
    }
}

