/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.yyanchor.revenue.argift;

import com.unionyy.mobile.yyanchor.revenue.argift.ARQueueManager;
import com.unionyy.mobile.yyanchor.revenue.argift.ArEntity;
import com.yy.mediaframework.facedetection.IPreProcessListener;
import com.yy.mobile.pluginstartlive.component.cover.preview.utils.VideoFilterManager;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.anchor.Publisher;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;

public class NewThreadARQueueManager
implements ARQueueManager {
    private static final String TAG = "ArQueueManager";
    private static final ARQueueManager instance = new NewThreadARQueueManager();
    private final BlockingQueue<ArEntity> messages;
    private volatile boolean runFlag = false;
    private Thread arThread;
    private final Lock playEffectLock = new ReentrantLock();
    private final Condition stopEffect = this.playEffectLock.newCondition();
    private volatile boolean playingEffect = false;
    private Runnable showArRunnable = new Runnable(){

        @Override
        public void run() {
            while (NewThreadARQueueManager.this.runFlag && !Thread.interrupted()) {
                try {
                    ArEntity entity = (ArEntity)NewThreadARQueueManager.this.messages.take();
                    String effectFilePath = entity.getPath().getAbsolutePath();
                    MLog.debug((Object)NewThreadARQueueManager.TAG, (String)("showArRunnable loop entity = " + effectFilePath), (Object[])new Object[0]);
                    NewThreadARQueueManager.this.playingEffect = true;
                    Publisher.getInstance().getVideoFilter().setGiftEffect(effectFilePath);
                    NewThreadARQueueManager.this.playEffectLock.lockInterruptibly();
                    try {
                        while (NewThreadARQueueManager.this.playingEffect) {
                            NewThreadARQueueManager.this.stopEffect.await();
                        }
                    }
                    finally {
                        NewThreadARQueueManager.this.playEffectLock.unlock();
                    }
                }
                catch (InterruptedException e) {
                    NewThreadARQueueManager.this.runFlag = false;
                }
            }
        }
    };

    public static ARQueueManager getInstance() {
        return instance;
    }

    private NewThreadARQueueManager() {
        this.messages = new PriorityBlockingQueue<ArEntity>();
        VideoFilterManager.getInstance().addListener(new IPreProcessListener(){

            public void onPreProcessStatus(int status) {
                if (status == 5) {
                    MLog.info((Object)NewThreadARQueueManager.TAG, (String)("onPreProcessStatus stop  = " + status), (Object[])new Object[0]);
                    NewThreadARQueueManager.this.playEffectLock.lock();
                    try {
                        NewThreadARQueueManager.this.playingEffect = false;
                        NewThreadARQueueManager.this.stopEffect.signal();
                    }
                    finally {
                        NewThreadARQueueManager.this.playEffectLock.unlock();
                    }
                }
            }

            public void animationCallbackBlock(String s, int i, int i1) {
            }
        });
    }

    @Override
    public void add(@NotNull ArEntity entity) {
        this.messages.add(entity);
        this.start();
    }

    private synchronized void start() {
        if (!this.runFlag) {
            this.runFlag = true;
            this.arThread = new Thread(this.showArRunnable);
            this.arThread.start();
        }
    }

    @Override
    public synchronized void destroy() {
        if (this.runFlag) {
            if (this.arThread != null) {
                this.arThread.interrupt();
                this.arThread = null;
            }
            this.messages.clear();
            this.runFlag = false;
        }
    }
}

