/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.yyanchor.revenue.argift;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.unionyy.mobile.yyanchor.revenue.argift.ARQueueManager;
import com.unionyy.mobile.yyanchor.revenue.argift.ArEntity;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.http.ProgressInfo;
import com.yy.mobile.http.ProgressListener;
import com.yy.mobile.http.RequestError;
import com.yy.mobile.http.RequestManager;
import com.yy.mobile.http.ResponseErrorListener;
import com.yy.mobile.http.ResponseListener;
import com.yy.mobile.pref2.SharedPreferencesUtils;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.FileUtil;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.gift.GiftConfigParser;
import com.yymobile.core.gift.GiftStickerItem;
import com.yymobile.core.mobilelive.MobileLiveFileUtil;
import io.reactivex.Observable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class ARGiftManager {
    private static final String PREFERENCE_NAME = "ARGiftManagerPreferences";
    private static final String PREFERENCE_KEY_RES_MD5_PRE_FIX = "res_md5_";
    private static final String TAG = "ARGiftManager";
    private static final String STICKER_DIR = "giftstickers";
    private static final String NOMEDIA = ".nomedia";
    private static final File StickerPath = new File(BasicConfig.getInstance().getRootDir() + File.separator + "giftstickers");
    private List<GiftStickerItem> mGiftStickeritems = new CopyOnWriteArrayList<GiftStickerItem>();
    private Set<Integer> mARGiftConfigItemMap = new HashSet<Integer>();
    private final ARQueueManager mQueueManager;
    private List<GiftStickerItem> mArWhenDowning = new CopyOnWriteArrayList<GiftStickerItem>();
    private SharedPreferences mARGiftManagerPreferences;

    public ARGiftManager(ARQueueManager queueManager) {
        this.mQueueManager = queueManager;
        this.mARGiftManagerPreferences = SharedPreferencesUtils.getSharedPreferences((Context)BasicConfig.getInstance().getAppContext(), (String)PREFERENCE_NAME, (int)0);
    }

    protected File getOrMkdirStickerPath() {
        if (!StickerPath.exists()) {
            StickerPath.mkdirs();
        }
        return StickerPath;
    }

    private synchronized void downloadAllWhatNeed() {
        MLog.info((Object)TAG, (String)("downloadAllWhatNeed() mGiftStickeritems.size=" + this.mGiftStickeritems.size()), (Object[])new Object[0]);
        for (int i = 0; i < this.mGiftStickeritems.size(); ++i) {
            final GiftStickerItem mGiftStickerItem = this.mGiftStickeritems.get(i);
            if (mGiftStickerItem.getGiftStickerStatus() != GiftStickerItem.GiftStickerStatus.UNDOWNLOAD) continue;
            mGiftStickerItem.setGiftStickerStatus(GiftStickerItem.GiftStickerStatus.DOWNLOADING);
            this.downloadStickerFile(mGiftStickerItem.url, new ResponseListener<String>(){

                @SuppressLint(value={"CheckResult"})
                public void onResponse(String response) {
                    MLog.info((Object)ARGiftManager.TAG, (String)("downloadAllWhatNeed() download succeeded: " + mGiftStickerItem.url), (Object[])new Object[0]);
                    Observable.just((Object)mGiftStickerItem).subscribeOn(Schedulers.io()).subscribe((Consumer)new Consumer<GiftStickerItem>(){

                        public void accept(GiftStickerItem i) {
                            ARGiftManager.this.decompressStickResourceAndExecuteQueue(i);
                        }
                    });
                }
            }, new ResponseErrorListener(){

                public void onErrorResponse(RequestError error) {
                    MLog.info((Object)ARGiftManager.TAG, (String)("downloadAllWhatNeed() download failed: " + mGiftStickerItem.url), (Object[])new Object[0]);
                    mGiftStickerItem.setGiftStickerStatus(GiftStickerItem.GiftStickerStatus.UNDOWNLOAD);
                }
            }, new ProgressListener(){

                public void onProgress(ProgressInfo info) {
                }
            });
        }
    }

    @SuppressLint(value={"CheckResult", "Rx#subscribe\u4f7f\u7528"})
    public void initData() {
        List aRGiftConfigItems = GiftConfigParser.getInstance().getVrPropsList();
        this.checkPathAndNoMedia();
        if (aRGiftConfigItems.size() > 0) {
            for (GiftConfigParser.VRGiftConfigItem aritem : aRGiftConfigItems) {
                if (StringUtils.isEmpty((String)aritem.lv1Src).booleanValue() || StringUtils.isEmpty((String)aritem.lv2Src).booleanValue() || StringUtils.isEmpty((String)aritem.lv3Src).booleanValue() || this.mARGiftConfigItemMap.contains(aritem.type)) continue;
                this.mARGiftConfigItemMap.add(aritem.type);
                List items = GiftStickerItem.fromArGiftConfigItem((GiftConfigParser.VRGiftConfigItem)aritem);
                this.mGiftStickeritems.addAll(items);
            }
            Observable.just(this.mGiftStickeritems).subscribeOn(Schedulers.io()).subscribe((Consumer)new Consumer<List<GiftStickerItem>>(){

                public void accept(List<GiftStickerItem> items) {
                    ARGiftManager.this.removeInaccuracyStickerFileCache(items.toArray(new GiftStickerItem[0]));
                    for (GiftStickerItem item : items) {
                        String verifyMd5 = ARGiftManager.this.getPreferenceResourceMd5(item);
                        if (!TextUtils.isEmpty((CharSequence)verifyMd5) && verifyMd5.equals(ARGiftManager.this.cacheMd5(item))) {
                            item.setGiftStickerStatus(GiftStickerItem.GiftStickerStatus.DECOMPRESSED);
                            continue;
                        }
                        item.setGiftStickerStatus(GiftStickerItem.GiftStickerStatus.UNDOWNLOAD);
                    }
                    ARGiftManager.this.downloadAllWhatNeed();
                }
            });
        }
    }

    @SuppressLint(value={"CheckResult"})
    void openFaceStickerWithInfo(int type, int grade) {
        GiftStickerItem item = this.getGiftStickerItemByid(type, grade);
        if (item == null) {
            return;
        }
        Observable.just((Object)item).subscribeOn(Schedulers.io()).subscribe((Consumer)new Consumer<GiftStickerItem>(){

            public void accept(final GiftStickerItem item) {
                ARGiftManager.this.removeInaccuracyStickerFileCache(new GiftStickerItem[]{item});
                ARGiftManager.this.downloadAllWhatNeed();
                GiftStickerItem.GiftStickerStatus status = item.getGiftStickerStatus();
                MLog.info((Object)ARGiftManager.TAG, (String)("openFaceStickerWithInfo status: " + status + ", item: " + item), (Object[])new Object[0]);
                switch (item.getGiftStickerStatus()) {
                    case UNDOWNLOAD: {
                        ARGiftManager.this.mArWhenDowning.add(item);
                        item.setGiftStickerStatus(GiftStickerItem.GiftStickerStatus.DOWNLOADING);
                        ARGiftManager.this.downloadStickerFile(item.url, (ResponseListener<String>)new ResponseListener(){

                            public void onResponse(Object response) {
                                MLog.info((Object)ARGiftManager.TAG, (String)("openFaceStickerWithInfo() download succeeded: " + item.url), (Object[])new Object[0]);
                                Observable.just((Object)item).subscribeOn(Schedulers.io()).subscribe((Consumer)new Consumer<GiftStickerItem>(){

                                    public void accept(GiftStickerItem i) {
                                        ARGiftManager.this.decompressStickResourceAndExecuteQueue(i);
                                    }
                                });
                            }
                        }, new ResponseErrorListener(){

                            public void onErrorResponse(RequestError error) {
                                MLog.error((Object)ARGiftManager.TAG, (String)("openFaceStickerWithInfo() download fail: " + item.url), (Object[])new Object[0]);
                                item.setGiftStickerStatus(GiftStickerItem.GiftStickerStatus.UNDOWNLOAD);
                            }
                        }, new ProgressListener(){

                            public void onProgress(ProgressInfo info) {
                            }
                        });
                        break;
                    }
                    case DOWNLOADING: 
                    case DECOMPRESSING: {
                        ARGiftManager.this.mArWhenDowning.add(item);
                        break;
                    }
                    case DECOMPRESSED: {
                        ARGiftManager.this.showArGift(item);
                        break;
                    }
                }
            }
        });
    }

    public void ondispose() {
        this.mGiftStickeritems.clear();
        this.mARGiftConfigItemMap.clear();
        this.mQueueManager.destroy();
        this.mArWhenDowning.clear();
    }

    private synchronized void removeInaccuracyStickerFileCache(GiftStickerItem ... giftStickerItems) {
        MLog.info((Object)TAG, (String)("removeInaccuracyStickerFileCache() giftStickerItems.length=" + giftStickerItems.length), (Object[])new Object[0]);
        try {
            for (GiftStickerItem item : giftStickerItems) {
                if (item.getGiftStickerStatus() == GiftStickerItem.GiftStickerStatus.DECOMPRESSING) continue;
                File stickerFileDir = new File(this.getOrMkdirStickerPath(), item.id);
                File[] resourceFiles = stickerFileDir.listFiles();
                if (!stickerFileDir.exists()) {
                    item.setGiftStickerStatus(GiftStickerItem.GiftStickerStatus.UNDOWNLOAD);
                    MLog.info((Object)TAG, (String)("stickerFileDir is not exists. " + item), (Object[])new Object[0]);
                    continue;
                }
                if (resourceFiles == null) {
                    item.setGiftStickerStatus(GiftStickerItem.GiftStickerStatus.UNDOWNLOAD);
                    MLog.info((Object)TAG, (String)("resourceFiles is not exists. " + item), (Object[])new Object[0]);
                    FileUtil.delete((File)stickerFileDir);
                    continue;
                }
                String fileEffect = this.getAREffectName(item);
                if (TextUtils.isEmpty((CharSequence)fileEffect)) {
                    item.setGiftStickerStatus(GiftStickerItem.GiftStickerStatus.UNDOWNLOAD);
                    MLog.info((Object)TAG, (String)("can not get file \".oeffect\" path. " + item), (Object[])new Object[0]);
                    FileUtil.delete((File)stickerFileDir);
                    continue;
                }
                File effectFile = new File(stickerFileDir, fileEffect);
                if (!effectFile.exists()) {
                    item.setGiftStickerStatus(GiftStickerItem.GiftStickerStatus.UNDOWNLOAD);
                    MLog.info((Object)TAG, (String)("file \".oeffect\" not found. " + item), (Object[])new Object[0]);
                    FileUtil.delete((File)stickerFileDir);
                    continue;
                }
                String verifyMd5 = this.getPreferenceResourceMd5(item);
                String cacheMd5 = this.cacheMd5(item);
                if (!TextUtils.isEmpty((CharSequence)verifyMd5) && verifyMd5.equals(cacheMd5)) continue;
                item.setGiftStickerStatus(GiftStickerItem.GiftStickerStatus.UNDOWNLOAD);
                MLog.info((Object)TAG, (String)("Md5 verify failed. " + item), (Object[])new Object[0]);
                FileUtil.delete((File)stickerFileDir);
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    private void checkPathAndNoMedia() {
        File file = new File(this.getOrMkdirStickerPath(), NOMEDIA);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                MLog.info((Object)TAG, (String)("Face checkPathAndNoMedia error  " + e.toString()), (Object[])new Object[0]);
            }
        }
    }

    private void downloadStickerFile(String url, ResponseListener<String> responseListener, ResponseErrorListener errorListener, ProgressListener progressListener) {
        File file = new File(this.getOrMkdirStickerPath(), GiftStickerItem.getFileNameByUrl((String)url));
        if (file.exists()) {
            FileUtil.delete((File)file);
        }
        RequestManager.instance().submitDownloadRequest(url, file.getAbsolutePath(), responseListener, errorListener, progressListener, false);
    }

    private synchronized void decompressStickResourceAndExecuteQueue(GiftStickerItem info) {
        this.decompressStickResource(info);
        if (this.mArWhenDowning.remove(info)) {
            this.showArGift(info);
        }
    }

    private GiftStickerItem getGiftStickerItemByid(int type, int grade) {
        if (FP.size(this.mGiftStickeritems) > 0) {
            for (GiftStickerItem info : this.mGiftStickeritems) {
                if (info.type != type || grade != info.grade) continue;
                return info;
            }
        }
        return null;
    }

    private void showArGift(GiftStickerItem info) {
        File itemDir = new File(this.getOrMkdirStickerPath(), info.id);
        Object[] files = itemDir.listFiles(new AREffectFilter());
        if (FP.empty((Object[])files)) {
            return;
        }
        String effectName = this.getAREffectName(info);
        File effectFile = new File(itemDir, effectName);
        ArEntity entity = new ArEntity(effectFile, itemDir, info.grade);
        MLog.info((Object)TAG, (String)("showArGift() will done! show ar now: " + info), (Object[])new Object[0]);
        this.mQueueManager.add(entity);
    }

    private String getAREffectName(GiftStickerItem info) {
        File itemDir = new File(this.getOrMkdirStickerPath(), info.id);
        Object[] files = itemDir.listFiles(new AREffectFilter());
        if (FP.empty((Object[])files)) {
            return null;
        }
        return ((File)files[0]).getName();
    }

    private synchronized void decompressStickResource(GiftStickerItem info) {
        MLog.info((Object)TAG, (String)("method decompressStickResource ready. " + info), (Object[])new Object[0]);
        String zipPath = new File(this.getOrMkdirStickerPath(), info.id).getAbsolutePath();
        File zipFile = new File(this.getOrMkdirStickerPath(), info.filePath);
        GiftStickerItem.GiftStickerStatus state = info.getGiftStickerStatus();
        if (state == GiftStickerItem.GiftStickerStatus.DECOMPRESSING || state == GiftStickerItem.GiftStickerStatus.DECOMPRESSED) {
            MLog.info((Object)TAG, (String)("No need to decompress again: " + info), (Object[])new Object[0]);
            return;
        }
        if (!zipFile.exists()) {
            MLog.info((Object)TAG, (String)("method decompressStickResource ops. zip file not exists. " + info), (Object[])new Object[0]);
            info.setGiftStickerStatus(GiftStickerItem.GiftStickerStatus.UNDOWNLOAD);
            return;
        }
        try {
            info.setGiftStickerStatus(GiftStickerItem.GiftStickerStatus.DECOMPRESSING);
            FileUtil.unzip((File)zipFile, (String)zipPath, (String)"");
            zipFile.delete();
            String md5 = this.cacheMd5(info);
            this.setPreferenceResourceMd5(info, md5);
            info.setGiftStickerStatus(GiftStickerItem.GiftStickerStatus.DECOMPRESSED);
            MLog.info((Object)TAG, (String)("method decompressStickResource decompressed. " + info + " md5=" + md5), (Object[])new Object[0]);
        }
        catch (Exception e) {
            info.setGiftStickerStatus(GiftStickerItem.GiftStickerStatus.UNDOWNLOAD);
            MLog.error((Object)TAG, (String)e.toString(), (Object[])new Object[0]);
        }
        MLog.info((Object)TAG, (String)("method decompressStickResource done. " + info), (Object[])new Object[0]);
    }

    private String cacheMd5(GiftStickerItem item) {
        try {
            Object[] resourceFiles = new File(this.getOrMkdirStickerPath(), item.id).listFiles();
            if (FP.empty((Object[])resourceFiles)) {
                return "";
            }
            return MobileLiveFileUtil.filesMd5((File[])resourceFiles);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)e.getMessage(), (Object[])new Object[0]);
            return "";
        }
    }

    private String getPreferenceResourceMd5(GiftStickerItem item) {
        return this.mARGiftManagerPreferences.getString(this.getPreferenceResourceMd5Key(item), "");
    }

    private void setPreferenceResourceMd5(GiftStickerItem item, String md5) {
        this.mARGiftManagerPreferences.edit().putString(this.getPreferenceResourceMd5Key(item), md5).apply();
    }

    private String getPreferenceResourceMd5Key(GiftStickerItem item) {
        return PREFERENCE_KEY_RES_MD5_PRE_FIX + item.id;
    }

    static class AREffectFilter
    implements FileFilter {
        AREffectFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName();
            return name.endsWith(".ofeffect");
        }
    }
}

