/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.yyanchor.login.phonenum.country;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import com.unionyy.mobile.yyanchor.R;
import com.unionyy.mobile.yyanchor.login.phonenum.country.CountryAdapter;
import com.unionyy.mobile.yyanchor.login.phonenum.country.CountryHelper;
import com.unionyy.mobile.yyanchor.login.phonenum.country.IndexableListView;
import com.unionyy.mobile.yyanchor.login.phonenum.country.UdbEditText;
import com.yy.mobile.android.arouter.facade.annotation.Route;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.util.log.MLog;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

@Route(path="/Select/Country")
public class CountrySelectActivity
extends BaseActivity {
    private static final String TAG = "CountrySelectActivity";
    public static final int COUNTRY_SELECT_REQ_CODE = 345;
    public static final String EXTRA_COUNTRY_INFO = "country_info";
    private SimpleTitleBar mTitleBar;
    private UdbEditText mEtKeyWord;
    private List<CountryHelper.CountryInfo> mAllItems;
    private IndexableListView mListView;
    private CountryAdapter mCountryAdapter;
    private InputMethodManager manager;
    private long mKeywordChangeTime = 0L;
    AdapterView.OnItemClickListener onItemClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            if (!CountrySelectActivity.this.mCountryAdapter.isSeperateItem(position)) {
                MLog.info((Object)CountrySelectActivity.TAG, (String)("List is clicked, position = " + position), (Object[])new Object[0]);
                Intent intent = new Intent();
                intent.putExtra(CountrySelectActivity.EXTRA_COUNTRY_INFO, (Serializable)((CountryHelper.CountryInfo)CountrySelectActivity.this.mCountryAdapter.getItem(position)));
                intent.putExtra("country_info_", ((CountryHelper.CountryInfo)((CountrySelectActivity)CountrySelectActivity.this).mCountryAdapter.getItem((int)position)).number);
                CountrySelectActivity.this.setResult(345, intent);
                CountrySelectActivity.this.finish();
            }
        }
    };
    TextWatcher onKeyWordChangeListener = new TextWatcher(){

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void afterTextChanged(Editable s) {
            if (System.currentTimeMillis() - CountrySelectActivity.this.mKeywordChangeTime > 200L) {
                CountrySelectActivity.this.showFilterItems(s.toString());
                CountrySelectActivity.this.mKeywordChangeTime = System.currentTimeMillis();
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.layout_country_select_activity);
        MLog.info((Object)TAG, (String)"onCreate()", (Object[])new Object[0]);
        this.manager = (InputMethodManager)this.getSystemService("input_method");
        this.mEtKeyWord = (UdbEditText)this.findViewById(R.id.ua_fragment_country_select_et_keyword);
        this.mListView = (IndexableListView)this.findViewById(R.id.ua_fragment_country_select_listview);
        this.mListView.setFastScrollEnabled(true);
        this.mListView.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView view, int scrollState) {
                if (scrollState == 1 && CountrySelectActivity.this.getCurrentFocus() != null && CountrySelectActivity.this.getCurrentFocus().getWindowToken() != null) {
                    CountrySelectActivity.this.manager.hideSoftInputFromWindow(CountrySelectActivity.this.getCurrentFocus().getWindowToken(), 2);
                }
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            }
        });
        this.mTitleBar = (SimpleTitleBar)this.findViewById(R.id.ua_fragment_country_select_title_bar);
        this.mTitleBar.setTitlte("\u9009\u62e9\u56fd\u5bb6/\u5730\u533a");
        this.mTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                CountrySelectActivity.this.finish();
            }
        });
        this.mEtKeyWord.bindCleanButton(R.id.ua_fragment_country_select_btn_clear_keyword);
        this.mEtKeyWord.addTextChangedListener(this.onKeyWordChangeListener);
        this.mEtKeyWord.setFocusable(false);
        this.mEtKeyWord.postDelayed(new Runnable(){

            @Override
            public void run() {
                CountrySelectActivity.this.mEtKeyWord.setFocusableInTouchMode(true);
                CountrySelectActivity.this.mEtKeyWord.setFocusable(true);
            }
        }, 1000L);
    }

    protected void onResume() {
        super.onResume();
        MLog.info((Object)TAG, (String)"onResume()", (Object[])new Object[0]);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    CountrySelectActivity.this.mAllItems = CountryHelper.getAllCountryList((Context)CountrySelectActivity.this);
                    CountrySelectActivity.this.getHandler().post(new Runnable(){

                        @Override
                        public void run() {
                            CountrySelectActivity.this.showAllItems();
                        }
                    });
                }
                catch (IOException e) {
                    MLog.error((Object)CountrySelectActivity.TAG, (String)"CountrySelect load country list error.", (Object[])new Object[0]);
                }
            }
        }).start();
    }

    private void showAllItems() {
        this.mCountryAdapter = new CountryAdapter(this.getContext(), this.mAllItems);
        this.mListView.setAdapter((ListAdapter)this.mCountryAdapter);
        this.mListView.setOnItemClickListener(this.onItemClickListener);
    }

    private void showFilterItems(String keyword) {
        if (this.mAllItems == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)keyword)) {
            this.showAllItems();
            return;
        }
        Locale locale = Locale.getDefault();
        ArrayList<CountryHelper.CountryInfo> filterInfos = new ArrayList<CountryHelper.CountryInfo>();
        int size = this.mAllItems.size();
        for (int i = 0; i < size; ++i) {
            CountryHelper.CountryInfo info = this.mAllItems.get(i);
            if (!(info.name != null && info.name.toLowerCase(locale).startsWith(keyword.toLowerCase(locale)) || info.pinyin != null && info.pinyin.toLowerCase(locale).startsWith(keyword.toLowerCase(locale))) && (info.pinyinShouzimu == null || !info.pinyinShouzimu.toLowerCase(locale).startsWith(keyword.toLowerCase(locale)))) continue;
            if (filterInfos.contains(info)) {
                filterInfos.remove(info);
            }
            filterInfos.add(info);
        }
        this.mCountryAdapter = new CountryAdapter(this.getContext(), filterInfos);
        this.mListView.setAdapter((ListAdapter)this.mCountryAdapter);
        this.mListView.setOnItemClickListener(this.onItemClickListener);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 0 && this.getCurrentFocus() != null && this.getCurrentFocus().getWindowToken() != null) {
            this.manager.hideSoftInputFromWindow(this.getCurrentFocus().getWindowToken(), 2);
        }
        return super.onTouchEvent(event);
    }
}

