/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.yyanchor.login.phonenum.country;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.widget.Adapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.unionyy.mobile.yyanchor.login.phonenum.country.IndexScroller;

public class IndexableListView
extends ListView {
    private boolean mIsFastScrollEnabled = false;
    private IndexScroller mScroller = null;
    private GestureDetector mGestureDetector = null;

    public IndexableListView(Context context) {
        super(context);
    }

    public IndexableListView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public IndexableListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public boolean isFastScrollEnabled() {
        return this.mIsFastScrollEnabled;
    }

    public void setFastScrollEnabled(boolean enabled) {
        this.mIsFastScrollEnabled = enabled;
        if (this.mIsFastScrollEnabled) {
            if (this.mScroller == null) {
                this.mScroller = new IndexScroller(this.getContext(), this);
                this.mScroller.show();
            }
        } else if (this.mScroller != null) {
            this.mScroller.hide();
            this.mScroller = null;
        }
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mScroller != null) {
            this.mScroller.draw(canvas);
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mScroller != null && this.mScroller.onTouchEvent(ev)) {
            return true;
        }
        if (this.mGestureDetector == null) {
            this.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

                public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                    if (IndexableListView.this.mScroller != null) {
                        IndexableListView.this.mScroller.show();
                    }
                    return super.onFling(e1, e2, velocityX, velocityY);
                }
            });
        }
        this.mGestureDetector.onTouchEvent(ev);
        return super.onTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mScroller.contains(ev.getX(), ev.getY())) {
            return true;
        }
        return super.onInterceptTouchEvent(ev);
    }

    public void setAdapter(ListAdapter adapter) {
        super.setAdapter(adapter);
        if (this.mScroller != null) {
            this.mScroller.setAdapter((Adapter)adapter);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mScroller != null) {
            this.mScroller.onSizeChanged(w, h, oldw, oldh);
        }
    }
}

