/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.yyanchor.login.phonenum.country;

import android.content.Context;
import com.unionyy.mobile.yyanchor.R;
import com.yy.mobile.util.log.MLog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CountryHelper {
    private static final String TAG = "CountryHelper";
    public static final String INDEX = "#ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String SEPERATE = "-----123---321-----";

    public static List<CountryInfo> getAllCountryList(Context context) throws IOException {
        if (context == null) {
            return new ArrayList<CountryInfo>();
        }
        InputStream is = context.getResources().openRawResource(R.raw.country_new);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        ArrayList<CountryInfo> results = new ArrayList<CountryInfo>();
        String line = null;
        while ((line = br.readLine()) != null) {
            CountryInfo info = CountryInfo.parseString(line);
            if (info == null) continue;
            results.add(info);
        }
        br.close();
        is.close();
        return results;
    }

    public static boolean matchIgnoreCase(char a, char b) {
        boolean match = a == b || a - 32 == b || a + 32 == b;
        return match;
    }

    public static class CountryInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String name = "";
        public String englishName = "";
        public String pinyin = "";
        public String pinyinShouzimu = "";
        public String number = "";

        public static CountryInfo parseString(String content) {
            if (content == null || content.length() <= 0) {
                MLog.error((Object)CountryHelper.TAG, (String)"\u83b7\u53d6\u56fd\u5bb6\u533a\u53f7\u51fa\u9519\uff1acontent\u4e3a\u7a7a", (Object[])new Object[0]);
                return null;
            }
            String[] fileds = content.split("\t");
            if (fileds == null || fileds.length <= 0) {
                MLog.error((Object)CountryHelper.TAG, (String)"\u83b7\u53d6\u56fd\u5bb6\u533a\u53f7\u51fa\u9519\uff1a\u65e0\u5b57\u6bb5", (Object[])new Object[0]);
                return null;
            }
            if (fileds[0].contains(CountryHelper.SEPERATE)) {
                CountryInfo info = new CountryInfo();
                info.name = fileds[0];
                return info;
            }
            if (fileds.length >= 5) {
                CountryInfo info = new CountryInfo();
                info.name = fileds[0];
                info.englishName = fileds[1];
                info.pinyin = fileds[2];
                info.pinyinShouzimu = fileds[3];
                info.number = fileds[4];
                return info;
            }
            MLog.error((Object)CountryHelper.TAG, (String)("\u83b7\u53d6\u56fd\u5bb6\u533a\u53f7\u51fa\u9519\uff1a" + content), (Object[])new Object[0]);
            return null;
        }

        public String toString() {
            return String.format("%s\t%s\t%s\t%s\t%s", this.name, this.englishName, this.pinyin, this.pinyinShouzimu, this.number);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CountryInfo that = (CountryInfo)o;
            return this.name != null ? this.name.equals(that.name) : that.name == null;
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }
    }
}

