/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.yyanchor.login.phonenum.country;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.SectionIndexer;
import android.widget.TextView;
import com.unionyy.mobile.yyanchor.R;
import com.unionyy.mobile.yyanchor.login.phonenum.country.CountryHelper;
import java.util.List;

public class CountryAdapter
extends BaseAdapter
implements SectionIndexer {
    private static final String INDEX = "#ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String SEPERATE = "-----123---321-----";
    private LayoutInflater mInflater;
    private List<CountryHelper.CountryInfo> mInfos;
    private float mDensity;

    public CountryAdapter(Context context, List<CountryHelper.CountryInfo> infos) {
        this.mInflater = LayoutInflater.from((Context)context);
        this.mInfos = infos;
        this.mDensity = context.getResources().getDisplayMetrics().density;
    }

    public int getCount() {
        return this.mInfos == null ? 0 : this.mInfos.size();
    }

    public Object getItem(int position) {
        return this.mInfos == null ? null : this.mInfos.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public boolean isSeperateItem(int position) {
        return this.mInfos.get((int)position).name.contains(SEPERATE);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (convertView == null) {
            convertView = this.mInflater.inflate(R.layout.ua_item_country, parent, false);
        }
        TextView tvname = (TextView)convertView.findViewById(R.id.ua_item_country_name);
        TextView tvnumber = (TextView)convertView.findViewById(R.id.ua_item_country_number);
        CountryHelper.CountryInfo info = this.mInfos.get(position);
        if (!info.name.contains(SEPERATE)) {
            int paddingLeftRight = (int)(this.mDensity * 15.0f);
            int height = (int)(this.mDensity * 45.0f);
            convertView.setPadding(paddingLeftRight, 0, paddingLeftRight, 0);
            convertView.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, height));
            convertView.setBackgroundResource(R.drawable.ua_selector_list_item);
            tvname.setText((CharSequence)info.name);
            tvname.setTextColor(-13421773);
            tvnumber.setVisibility(0);
            tvnumber.setText((CharSequence)info.number);
        } else {
            int paddingLeftRight = (int)(this.mDensity * 17.0f);
            int height = (int)(this.mDensity * 30.0f);
            convertView.setPadding(paddingLeftRight, 0, paddingLeftRight, 0);
            convertView.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, height));
            convertView.setBackgroundColor(-592138);
            tvname.setText((CharSequence)info.name.replace(SEPERATE, ""));
            tvname.setTextColor(-9013642);
            tvnumber.setVisibility(8);
        }
        return convertView;
    }

    public Object[] getSections() {
        Object[] sections = new String[INDEX.length()];
        for (int i = 0; i < INDEX.length(); ++i) {
            sections[i] = String.valueOf(INDEX.charAt(i));
        }
        return sections;
    }

    public int getPositionForSection(int sectionIndex) {
        if (sectionIndex == 0) {
            return 0;
        }
        char section = ((String)this.getSections()[sectionIndex]).charAt(0);
        for (int i = this.getCount() - 1; i > 0; --i) {
            CountryHelper.CountryInfo ci = this.mInfos.get(i);
            if (!ci.name.contains(SEPERATE) || !CountryHelper.matchIgnoreCase(section, ci.name.charAt(0))) continue;
            return i;
        }
        return 0;
    }

    public int getSectionForPosition(int position) {
        return 0;
    }
}

