/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.grpc;

import com.lightstep.tracer.grpc.Auth;
import com.lightstep.tracer.grpc.InternalMetrics;
import com.lightstep.tracer.grpc.Reporter;
import com.lightstep.tracer.grpc.Span;
import java.util.ArrayList;
import java.util.List;

public class ReportRequest {
    public Reporter reporter;
    public Auth auth;
    public List<Span> spans;
    public int timestampOffsetMicros;
    public InternalMetrics internalMetrics;

    public ReportRequest(Reporter reporter, Auth auth, List<Span> spans, int timestampOffsetMicros, InternalMetrics internalMetrics) {
        this.reporter = reporter;
        this.auth = auth;
        this.spans = spans;
        this.timestampOffsetMicros = timestampOffsetMicros;
        this.internalMetrics = internalMetrics;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Reporter.Builder reportBuilder;
        private Auth.Builder authBuilder;
        private List<Span> spans;
        private int timestampOffsetNanos;
        private InternalMetrics internalMetrics;

        public Builder setSpans(List<Span> spans) {
            this.spans = spans;
            return this;
        }

        public Builder setTimestampOffsetNanos(int timestampOffsetNanos) {
            this.timestampOffsetNanos = timestampOffsetNanos;
            return this;
        }

        public Builder setInternalMetrics(InternalMetrics internalMetrics) {
            this.internalMetrics = internalMetrics;
            return this;
        }

        public ReportRequest build() {
            Reporter reporter = this.reportBuilder.build();
            Auth auth = this.authBuilder.build();
            return new ReportRequest(reporter, auth, this.spans, this.timestampOffsetNanos, this.internalMetrics);
        }

        public Builder setReporter(Reporter.Builder reporterBuilder) {
            this.reportBuilder = reporterBuilder;
            return this;
        }

        public Builder setAuth(Auth.Builder authBuilder) {
            this.authBuilder = authBuilder;
            return this;
        }

        public Builder addAllSpans(List<Span> spanList) {
            if (this.spans == null) {
                this.spans = new ArrayList<Span>();
            }
            this.spans.addAll(spanList);
            return this;
        }
    }
}

