/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.grpc;

public final class KeyValue {
    public String key;
    public Object value;

    public KeyValue(String key, Object value) {
        this.key = key;
        this.value = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getKey() {
        return this.key;
    }

    public String getStringValue() {
        return this.value.toString();
    }

    public static class Builder {
        private String key;
        private Object value;

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public Builder setValue(Object value) {
            this.value = value;
            return this;
        }

        public KeyValue build() {
            return new KeyValue(this.key, this.value);
        }

        public Builder setStringValue(String value) {
            this.value = value;
            return this;
        }

        public Builder setBoolValue(Boolean value) {
            this.value = value;
            return this;
        }

        public Builder setIntValue(long l) {
            this.value = l;
            return this;
        }

        public Builder setDoubleValue(double v) {
            this.value = v;
            return this;
        }

        public Builder setJsonValue(String v) {
            this.value = v;
            return this;
        }
    }
}

