/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.grpc;

import com.lightstep.tracer.grpc.KeyValue;
import java.util.ArrayList;
import java.util.List;

public class Reporter {
    public long reporterId;
    public List<KeyValue> tags;

    public Reporter(long reporterId, List<KeyValue> tags) {
        this.reporterId = reporterId;
        this.tags = tags;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private long reporterId;
        private List<KeyValue> tags;

        public Builder setReporterId(long reporterId) {
            this.reporterId = reporterId;
            return this;
        }

        public Builder setTags(List<KeyValue> tags) {
            this.tags = tags;
            return this;
        }

        public Reporter build() {
            return new Reporter(this.reporterId, this.tags);
        }

        public Builder addTags(KeyValue.Builder keyValueBuilder) {
            if (this.tags == null) {
                this.tags = new ArrayList<KeyValue>();
            }
            this.tags.add(keyValueBuilder.build());
            return this;
        }

        public List<KeyValue> getTagsList() {
            return this.tags;
        }
    }
}

