/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.grpc;

import com.lightstep.tracer.grpc.KeyValue;
import java.util.ArrayList;
import java.util.List;

public class Log {
    public long timestamp;
    public List<KeyValue> keyvalues;

    public Log(long timestamp, List<KeyValue> keyvalues) {
        this.timestamp = timestamp;
        this.keyvalues = keyvalues;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private long timestamp;
        private List<KeyValue> keyvalues;

        public Builder setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder setKeyvalues(List<KeyValue> keyvalues) {
            this.keyvalues = keyvalues;
            return this;
        }

        public Log build() {
            return new Log(this.timestamp, this.keyvalues);
        }

        public Builder addKeyvalues(KeyValue kv) {
            if (this.keyvalues == null) {
                this.keyvalues = new ArrayList<KeyValue>();
                this.keyvalues.add(kv);
            }
            return this;
        }
    }
}

