/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.grpc;

import com.lightstep.tracer.grpc.Command;
import java.util.List;

public class ReportResponse {
    public List<Command> commands;
    public List<String> errors;
    public long receiveTimestamp;
    public long transmitTimestamp;

    public ReportResponse(List<Command> commands, List<String> errors, long receiveTimestamp, long transmitTimestamp) {
        this.commands = commands;
        this.errors = errors;
        this.receiveTimestamp = receiveTimestamp;
        this.transmitTimestamp = transmitTimestamp;
    }

    public ReportResponse() {
    }

    public List<String> getErrorsList() {
        return this.errors;
    }

    public boolean hasReceiveTimestamp() {
        return this.receiveTimestamp > 0L;
    }

    public boolean hasTransmitTimestamp() {
        return this.transmitTimestamp > 0L;
    }

    public int getCommandsCount() {
        return this.commands == null ? 0 : this.commands.size();
    }

    public List<Command> getCommandsList() {
        return this.commands;
    }

    public long getReceiveTimestamp() {
        return this.receiveTimestamp;
    }

    public long getTransmitTimestamp() {
        return this.transmitTimestamp;
    }

    public static class Builder {
        private List<Command> commands;
        private List<String> errors;
        private long receiveTimestamp;
        private long transmitTimestamp;

        public Builder setCommands(List<Command> commands) {
            this.commands = commands;
            return this;
        }

        public Builder setErrors(List<String> errors) {
            this.errors = errors;
            return this;
        }

        public Builder setReceiveTimestamp(long receiveTimestamp) {
            this.receiveTimestamp = receiveTimestamp;
            return this;
        }

        public Builder setTransmitTimestamp(long transmitTimestamp) {
            this.transmitTimestamp = transmitTimestamp;
            return this;
        }

        public ReportResponse build() {
            return new ReportResponse(this.commands, this.errors, this.receiveTimestamp, this.transmitTimestamp);
        }
    }
}

