/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.grpc;

import com.lightstep.tracer.grpc.KeyValue;
import com.lightstep.tracer.grpc.Log;
import com.lightstep.tracer.grpc.Reference;
import com.lightstep.tracer.grpc.SpanContext;
import java.util.ArrayList;
import java.util.List;

public class Span {
    public long durationNanos;
    public List<Log> logs;
    public String operationName;
    public List<Reference> references;
    public SpanContext spanContext;
    public long startTimestamp;
    public List<KeyValue> tags;

    public Span(long durationMicros, List<Log> logs, String operationName, List<Reference> references, SpanContext spanContext, long startTimestamp, List<KeyValue> tags) {
        this.durationNanos = durationMicros;
        this.logs = logs;
        this.operationName = operationName;
        this.references = references;
        this.spanContext = spanContext;
        this.startTimestamp = startTimestamp;
        this.tags = tags;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private long durationNano;
        private List<Log> logs;
        private String operationName;
        private List<Reference> references;
        private SpanContext spanContext;
        private long startTimestamp;
        private List<KeyValue> tags;

        public Builder setDurationNano(long durationNano) {
            this.durationNano = durationNano;
            return this;
        }

        public Builder setLogs(List<Log> logs) {
            this.logs = logs;
            return this;
        }

        public Builder setOperationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public Builder setReferences(List<Reference> references) {
            this.references = references;
            return this;
        }

        public Builder setSpanContext(SpanContext spanContext) {
            this.spanContext = spanContext;
            return this;
        }

        public Builder setStartTimestamp(long startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public Builder setTags(List<KeyValue> tags) {
            this.tags = tags;
            return this;
        }

        public Span build() {
            return new Span(this.durationNano, this.logs, this.operationName, this.references, this.spanContext, this.startTimestamp, this.tags);
        }

        public long getStartTimeNanos() {
            return this.startTimestamp;
        }

        public Builder addTags(KeyValue.Builder keyValueBuilder) {
            if (this.tags == null) {
                this.tags = new ArrayList<KeyValue>();
            }
            this.tags.add(keyValueBuilder.build());
            return this;
        }

        public Builder addLogs(Log log) {
            if (this.logs == null) {
                this.logs = new ArrayList<Log>();
            }
            this.logs.add(log);
            return this;
        }

        public Builder addReferences(Reference reference) {
            if (this.references == null) {
                this.references = new ArrayList<Reference>();
            }
            this.references.add(reference);
            return this;
        }

        public long getStartTimestamp() {
            return this.startTimestamp;
        }
    }
}

