/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.shared;

import com.lightstep.tracer.grpc.Reference;
import com.lightstep.tracer.grpc.Span;
import com.lightstep.tracer.shared.AbstractTracer;
import com.lightstep.tracer.shared.NoopSpan;
import com.lightstep.tracer.shared.Span;
import com.lightstep.tracer.shared.SpanContext;
import com.lightstep.tracer.shared.Util;
import io.opentracing.ActiveSpan;
import io.opentracing.BaseSpan;
import io.opentracing.Tracer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SpanBuilder
implements Tracer.SpanBuilder {
    static final String PARENT_SPAN_GUID_KEY = "parent_spanid";
    private final String operationName;
    private final Map<String, String> stringTags;
    private final Map<String, Boolean> boolTags;
    private final Map<String, Number> numTags;
    private final AbstractTracer tracer;
    private String traceId = null;
    private String spanId = null;
    private SpanContext parent;
    private long startTimestampNano;
    private boolean ignoringActiveSpan;
    private final Span.Builder grpcSpan = com.lightstep.tracer.grpc.Span.newBuilder();

    SpanBuilder(String operationName, AbstractTracer tracer) {
        this.operationName = operationName;
        this.tracer = tracer;
        this.stringTags = new HashMap<String, String>();
        this.boolTags = new HashMap<String, Boolean>();
        this.numTags = new HashMap<String, Number>();
    }

    public Tracer.SpanBuilder asChildOf(io.opentracing.SpanContext parent) {
        return this.addReference("CHILD_OF", parent);
    }

    public Tracer.SpanBuilder asChildOf(BaseSpan<?> parent) {
        if (parent == null) {
            return this;
        }
        return this.asChildOf(parent.context());
    }

    public Tracer.SpanBuilder addReference(String type, io.opentracing.SpanContext referredTo) {
        if (referredTo != null && ("CHILD_OF".equals(type) || "FOLLOWS_FROM".equals(type))) {
            this.parent = (SpanContext)referredTo;
            Reference.Builder refBuilder = Reference.newBuilder();
            refBuilder.setSpanContext(this.parent.getInnerSpanCtx());
            if ("CHILD_OF".equals(type)) {
                refBuilder.setRelationship("CHILD_OF");
            } else {
                refBuilder.setRelationship("FOLLOWS_FROM");
            }
            this.grpcSpan.addReferences(refBuilder.build());
        }
        return this;
    }

    public Tracer.SpanBuilder ignoreActiveSpan() {
        this.ignoringActiveSpan = true;
        return this;
    }

    public Tracer.SpanBuilder withTag(String key, String value) {
        this.stringTags.put(key, value);
        return this;
    }

    public Tracer.SpanBuilder withTag(String key, boolean value) {
        this.boolTags.put(key, value);
        return this;
    }

    public Tracer.SpanBuilder withTag(String key, Number value) {
        this.numTags.put(key, value);
        return this;
    }

    public Tracer.SpanBuilder withStartTimestamp(long timestampNano) {
        this.startTimestampNano = timestampNano;
        return this;
    }

    public ActiveSpan startActive() {
        io.opentracing.Span span = this.startManual();
        return this.tracer.makeActive(span);
    }

    public io.opentracing.Span start() {
        return this.startManual();
    }

    public Tracer.SpanBuilder withTraceIdAndSpanId(String traceId, String spanId) {
        this.traceId = traceId;
        this.spanId = spanId;
        return this;
    }

    public Iterable<Map.Entry<String, String>> baggageItems() {
        if (this.parent == null) {
            return Collections.emptySet();
        }
        return this.parent.baggageItems();
    }

    private SpanContext activeSpanContext() {
        ActiveSpan handle = this.tracer.activeSpan();
        if (handle == null) {
            return null;
        }
        io.opentracing.SpanContext spanContext = handle.context();
        if (spanContext instanceof SpanContext) {
            return (SpanContext)spanContext;
        }
        return null;
    }

    public io.opentracing.Span startManual() {
        if (this.tracer.isDisabled()) {
            return NoopSpan.INSTANCE;
        }
        long startTimestampRelativeNanos = -1L;
        if (this.startTimestampNano == 0L) {
            startTimestampRelativeNanos = System.nanoTime();
            this.startTimestampNano = Util.nowNanosApproximate();
        }
        this.grpcSpan.setOperationName(this.operationName);
        this.grpcSpan.setStartTimestamp(this.startTimestampNano);
        String traceId = this.traceId;
        if (this.parent == null && !this.ignoringActiveSpan) {
            this.parent = this.activeSpanContext();
        }
        if (this.parent != null) {
            traceId = this.parent.getTraceId();
            this.grpcSpan.addReferences(new Reference("CHILD_OF", this.parent.getInnerSpanCtx()));
        }
        SpanContext newSpanContext = traceId != null && this.spanId != null ? new SpanContext(traceId, this.spanId) : (traceId != null ? new SpanContext(traceId) : new SpanContext());
        this.grpcSpan.setSpanContext(newSpanContext.getInnerSpanCtx());
        Span span = new Span(this.tracer, newSpanContext, this.grpcSpan, startTimestampRelativeNanos);
        for (Map.Entry<String, String> entry : this.stringTags.entrySet()) {
            span.setTag(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.boolTags.entrySet()) {
            span.setTag(entry.getKey(), (Boolean)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.numTags.entrySet()) {
            span.setTag(entry.getKey(), (Number)entry.getValue());
        }
        return span;
    }
}

