/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.shared;

import com.google.gson.Gson;
import com.lightstep.tracer.grpc.KeyValue;
import com.lightstep.tracer.grpc.Log;
import com.lightstep.tracer.grpc.Reference;
import com.lightstep.tracer.grpc.ReportRequest;
import com.lightstep.tracer.grpc.ReportResponse;
import com.lightstep.tracer.grpc.Span;
import com.lightstep.tracer.shared.AbstractTracer;
import com.lightstep.tracer.shared.CollectorClient;
import com.lightstep.tracer.shared.Options;
import com.lightstep.tracer.shared.model.LogItem;
import com.lightstep.tracer.shared.model.SpanItem;
import com.lightstep.tracer.shared.model.TraceItem;
import com.yy.hiidostatis.api.StatisContent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HiidoCollectorClient
extends CollectorClient {
    private static final String table = "aomitraceclient";
    private final AbstractTracer tracer;
    private final String appId;

    public HiidoCollectorClient(AbstractTracer tracer, Options options) {
        this.tracer = tracer;
        this.appId = options.appId;
    }

    @Override
    void reconnect() {
    }

    @Override
    void shutdown() {
    }

    @Override
    ReportResponse report(ReportRequest request) {
        try {
            List<TraceItem> traceItemList = this.groupByTraceId(request.spans);
            for (TraceItem traceItem : traceItemList) {
                StatisContent statContent = new StatisContent();
                statContent.put("app", this.appId);
                String json = new Gson().toJson((Object)traceItem);
                statContent.put("tracedata", json);
                this.tracer.debug("tracedata: " + json);
                this.tracer.hiidoSDK.reportStatisticContent(table, statContent, true, true);
            }
        }
        catch (Throwable ex) {
            this.tracer.error("Hiido Report error:" + ex);
        }
        return new ReportResponse(null, Collections.emptyList(), 0L, 0L);
    }

    private List<TraceItem> groupByTraceId(List<Span> spanList) {
        ArrayList<TraceItem> traceItemList = new ArrayList<TraceItem>();
        for (Span span : spanList) {
            String traceId = span.spanContext.traceid;
            TraceItem target = this.find(traceItemList, traceId);
            if (target == null) {
                TraceItem ti = new TraceItem();
                ti.traceid = traceId;
                ti.addSpanItem(this.createSpanItem(span));
                traceItemList.add(ti);
                continue;
            }
            target.addSpanItem(this.createSpanItem(span));
        }
        return traceItemList;
    }

    private SpanItem createSpanItem(Span span) {
        SpanItem item = new SpanItem();
        item.traceid = span.spanContext.traceid;
        item.spanid = span.spanContext.spanid;
        item.operationname = span.operationName;
        item.duration = span.durationNanos;
        item.starttime = span.startTimestamp;
        item.tags = this.convertKeyValueList(span.tags);
        item.references = this.convertRef(span.references);
        item.logs = this.convertLogs(span.logs);
        return item;
    }

    private List<LogItem> convertLogs(List<Log> logList) {
        if (logList != null) {
            ArrayList<LogItem> logItemList = new ArrayList<LogItem>(logList.size());
            for (Log log : logList) {
                LogItem logItem = this.convertLog(log);
                logItemList.add(logItem);
            }
            return logItemList;
        }
        return null;
    }

    private LogItem convertLog(Log log) {
        LogItem logItem = new LogItem();
        logItem.timestamp = log.timestamp;
        logItem.value = this.convertKeyValueList(log.keyvalues);
        return logItem;
    }

    private List<Map<String, String>> convertRef(List<Reference> references) {
        if (references == null) {
            return null;
        }
        ArrayList<Map<String, String>> li = new ArrayList<Map<String, String>>();
        for (Reference r : references) {
            HashMap<String, String> m = new HashMap<String, String>(3);
            m.put("reftype", r.relationship);
            if (r.spanContext != null) {
                m.put("spanId", r.spanContext.spanid);
                m.put("traceId", r.spanContext.traceid);
            }
            li.add(m);
        }
        return li;
    }

    private Map<String, Object> convertKeyValueList(List<KeyValue> tags) {
        if (tags != null) {
            HashMap<String, Object> m = new HashMap<String, Object>(tags.size());
            for (KeyValue kv : tags) {
                m.put(kv.key, kv.value);
            }
            return m;
        }
        return null;
    }

    private TraceItem find(List<TraceItem> traceItemList, String traceId) {
        for (TraceItem it : traceItemList) {
            if (!traceId.equals(it.traceid)) continue;
            return it;
        }
        return null;
    }
}

