/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.shared;

import java.util.Random;
import java.util.UUID;

class Util {
    private static ThreadLocal<Random> random = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random(System.currentTimeMillis() * (System.nanoTime() % 1000000L) * Thread.currentThread().getId() * (long)(1024.0 * Math.random()));
        }
    };

    Util() {
    }

    static String generateRandomGUID() {
        return UUID.randomUUID().toString();
    }

    static int safeLongToInt(long l) throws IllegalArgumentException {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(l + " cannot be cast to an int without changing its value.");
        }
        return (int)l;
    }

    static long nowMicrosApproximate() {
        return System.currentTimeMillis() * 1000L;
    }

    static long nowNanosApproximate() {
        return System.currentTimeMillis() * 1000000L;
    }
}

