/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import android.util.Log;
import com.lightstep.tracer.shared.AbstractTracer;
import com.lightstep.tracer.shared.Options;
import com.lightstep.tracer.shared.SimpleFuture;

public class Tracer
extends AbstractTracer {
    private static final String TAG = "Tracer";
    private final Context ctx;
    private static final int ANDROID_DEFAULT_REPORTING_INTERVAL_MILLIS = 30000;
    private static Tracer INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(Context ctx, Options options) {
        if (INSTANCE != null) return;
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            if (INSTANCE != null) return;
            if (options.appId == null || options.appId.length() == 0) {
                throw new IllegalArgumentException("options.appId is null or empty");
            }
            INSTANCE = new Tracer(ctx.getApplicationContext(), options);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static Tracer get() {
        return INSTANCE;
    }

    private Tracer(Context ctx, Options options) {
        super(options.setDefaultReportingIntervalMillis(30000).disableResetClient(), ctx);
        this.ctx = ctx;
        this.addStandardTracerTags();
    }

    public void flush() {
        this.flush(10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SimpleFuture<Boolean> flushInternal(boolean explicitRequest) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.isDisabled() || this.ctx == null) {
                return new SimpleFuture<Boolean>(false);
            }
            SimpleFuture<Boolean> future = new SimpleFuture<Boolean>();
            AsyncFlush asyncFlush = new AsyncFlush(future, explicitRequest);
            asyncFlush.execute(new Void[0]);
            return future;
        }
    }

    private void addStandardTracerTags() {
        this.addTracerTag("lightstep.tracer_platform", "android");
        this.addTracerTag("lightstep.tracer_platform_version", String.valueOf(Build.VERSION.SDK_INT));
        this.addTracerTag("lightstep.tracer_version", "0.30.0");
    }

    @Override
    protected void printLogToConsole(AbstractTracer.InternalLogLevel level, String msg, Object payload) {
        String s = msg;
        if (payload != null) {
            s = s + " " + payload.toString();
        }
        switch (level) {
            case DEBUG: {
                Log.d((String)TAG, (String)s);
                break;
            }
            case INFO: {
                Log.i((String)TAG, (String)s);
                break;
            }
            case WARN: {
                Log.w((String)TAG, (String)s);
                break;
            }
            case ERROR: {
                Log.e((String)TAG, (String)s);
                break;
            }
            default: {
                Log.e((String)TAG, (String)s);
            }
        }
    }

    private class AsyncFlush
    extends AsyncTask<Void, Void, Void> {
        private SimpleFuture<Boolean> future;
        private boolean explicitRequest;

        AsyncFlush(SimpleFuture<Boolean> future, boolean explicitRequest) {
            this.future = future;
            this.explicitRequest = explicitRequest;
        }

        protected Void doInBackground(Void ... voids) {
            boolean ok = Tracer.this.sendReport(this.explicitRequest);
            this.future.set(ok);
            return null;
        }
    }
}

