/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.grpc;

import com.lightstep.tracer.grpc.Log;
import com.lightstep.tracer.grpc.MetricsSample;
import java.util.ArrayList;
import java.util.List;

public class InternalMetrics {
    public List<MetricsSample> counts;
    public long durationMicros;
    public List<MetricsSample> gauges;
    public List<Log> logs;
    public long startTimestamp;

    public InternalMetrics(List<MetricsSample> counts, long durationMicros, List<MetricsSample> gauges, List<Log> logs, long startTimestamp) {
        this.counts = counts;
        this.durationMicros = durationMicros;
        this.gauges = gauges;
        this.logs = logs;
        this.startTimestamp = startTimestamp;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private List<MetricsSample> counts;
        private long durationMicros;
        private List<MetricsSample> gauges;
        private List<Log> logs;
        private long startTimestamp;

        public Builder setCounts(List<MetricsSample> counts) {
            this.counts = counts;
            return this;
        }

        public Builder setDurationMicros(long durationMicros) {
            this.durationMicros = durationMicros;
            return this;
        }

        public Builder setGauges(List<MetricsSample> gauges) {
            this.gauges = gauges;
            return this;
        }

        public Builder setLogs(List<Log> logs) {
            this.logs = logs;
            return this;
        }

        public Builder setStartTimestamp(long startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public InternalMetrics build() {
            return new InternalMetrics(this.counts, this.durationMicros, this.gauges, this.logs, this.startTimestamp);
        }

        public Builder addCounts(MetricsSample metricsSample) {
            if (this.counts == null) {
                this.counts = new ArrayList<MetricsSample>();
            }
            this.counts.add(metricsSample);
            return this;
        }
    }
}

