package com.yy.mobile.framework.revenuesdk.gift.requestparam;

import java.util.ArrayList;

/**
 * Created by lhf on 2018/7/13.
 * <p>拉取全部礼物列表请求参数
 * YY.Inc
 */
public class LoadReceiveGiftAmountParam {

    public int appId; //分配给业务的appID 不填或者填0使用默认的appId
    public int channelId; //渠道id 不填或者填0使用默认的channelId
    public long uid; //用户uid
    public long sid; //当前频道，可以针对频道设置礼物的价格和是否展示(选填)
    public long ssid; //当前子频道，可以针对频道设置礼物的价格和是否展示(选填)
    public long anchorUid; // 主播uid（hello业务为要查询的用户uid）

    public ArrayList<Integer> retry; // 超时重试时间（单位毫秒）传NULL就是用默认重试策略.


    public LoadReceiveGiftAmountParam() {
        appId = 0;
        channelId = 0;
        uid = 0;
        sid = 0;
        ssid = 0;
        anchorUid = 0;
        retry = null;

    }

    public static final class LoadAllGiftParamBuilder {
        public int appId;
        public int channelId;
        public long uid;
        public long sid;
        public long ssid;
        public long anchorUid;
        public ArrayList<Integer> retry = null;


        private LoadAllGiftParamBuilder() {
        }

        public static LoadAllGiftParamBuilder aLoadAllGiftParam() {
            return new LoadAllGiftParamBuilder();
        }

        public LoadAllGiftParamBuilder setAppId(int appId) {
            this.appId = appId;
            return this;
        }

        public LoadAllGiftParamBuilder setChannelId(int channelId) {
            this.channelId = channelId;
            return this;
        }

        public LoadAllGiftParamBuilder setUid(long uid) {
            this.uid = uid;
            return this;
        }

        public LoadAllGiftParamBuilder setSid(long sid) {
            this.sid = sid;
            return this;
        }

        public LoadAllGiftParamBuilder setSsid(long ssid) {
            this.ssid = ssid;
            return this;
        }

        public LoadAllGiftParamBuilder setAnchorUid(long anchorUid) {
            this.anchorUid = anchorUid;
            return this;
        }

        public LoadAllGiftParamBuilder setRetry(ArrayList<Integer> retry) {
            this.retry = retry;
            return this;
        }

        public LoadReceiveGiftAmountParam build() {
            LoadReceiveGiftAmountParam loadAllGiftParam = new LoadReceiveGiftAmountParam();
            loadAllGiftParam.uid = this.uid;
            loadAllGiftParam.anchorUid = this.anchorUid;
            loadAllGiftParam.channelId = this.channelId;
            loadAllGiftParam.appId = this.appId;
            loadAllGiftParam.ssid = this.ssid;
            loadAllGiftParam.sid = this.sid;
            loadAllGiftParam.retry = this.retry;
            return loadAllGiftParam;
        }
    }
}
