package com.yy.mobile.framework.revenuesdk.gift.requestparam;

import java.util.ArrayList;

/**
 * Created by lhf on 2018/7/13.
 * <p>
 * YY.Inc
 */
public class LoadPackageGiftParam {

    public int appId; //分配给业务的appId 不填或者填0使用默认的appId
    public int channelId; //渠道id 不填或者填0使用默认的appId
    public long uid; //用户uid
    public long sid; //当前频道，可以针对频道设置礼物的价格和是否展示(选填)
    public long ssid; //当前子频道，可以针对频道设置礼物的价格和是否展示(选填)
    public ArrayList<Integer> retry; // 超时重试时间（单位毫秒）传NULL就是用默认重试策略.
    public String ticket; //验证需要，必填

    public LoadPackageGiftParam() {
        appId = 0;
        channelId = 0;
        uid = 0;
        sid = 0;
        ssid = 0;
        retry = null;
        ticket = "";
    }

    public static final class LoadPackageGiftParamBuilder {
        public int appId; //分配给业务的appId 不填或者填0使用默认的appId
        public int channelId; //渠道id 不填或者填0使用默认的appId
        public long uid; //用户uid
        public long sid; //当前频道，可以针对频道设置礼物的价格和是否展示(选填)
        public long ssid; //当前子频道，可以针对频道设置礼物的价格和是否展示(选填)
        public ArrayList<Integer> retry = null; // 超时重试时间（单位毫秒）传NULL就是用默认重试策略.
        public String ticket; //验证需要，必填

        private LoadPackageGiftParamBuilder() {
        }

        public static LoadPackageGiftParamBuilder aLoadPackageGiftParam() {
            return new LoadPackageGiftParamBuilder();
        }

        public LoadPackageGiftParamBuilder setAppId(int appId) {
            this.appId = appId;
            return this;
        }

        public LoadPackageGiftParamBuilder setChannelId(int channelId) {
            this.channelId = channelId;
            return this;
        }

        public LoadPackageGiftParamBuilder setUid(long uid) {
            this.uid = uid;
            return this;
        }

        public LoadPackageGiftParamBuilder setSid(long sid) {
            this.sid = sid;
            return this;
        }

        public LoadPackageGiftParamBuilder setSsid(long ssid) {
            this.ssid = ssid;
            return this;
        }

        public LoadPackageGiftParamBuilder setRetry(ArrayList<Integer> retry) {
            this.retry = retry;
            return this;
        }

        public LoadPackageGiftParamBuilder setTicket(String ticket) {
            this.ticket = ticket;
            return this;
        }

        public LoadPackageGiftParam build() {
            LoadPackageGiftParam loadPackageGiftParam = new LoadPackageGiftParam();
            loadPackageGiftParam.uid = this.uid;
            loadPackageGiftParam.sid = this.sid;
            loadPackageGiftParam.appId = this.appId;
            loadPackageGiftParam.channelId = this.channelId;
            loadPackageGiftParam.ssid = this.ssid;
            loadPackageGiftParam.retry = this.retry;
            loadPackageGiftParam.ticket = this.ticket;
            return loadPackageGiftParam;
        }
    }
}
