package com.yy.mobile.framework.revenuesdk.gift.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.IBaseJsonResponse;

import org.json.JSONObject;

/**
 * Created by lhf on 2018/7/13.
 * <p>
 * YY.Inc
 */
public class UseItemResponse implements IBaseJsonResponse {

//    # Response
//    {
//            "cmd":2007,
//            "seq":"$seq",   //
//            "uid":$uid,            //用户uid
//            "result":$result,           // 业务错误码：-1、-3、-4、-5, -10
//            "message":$message,           // 业务返回码信息说明
//
//            "propsId":$propsId,   // 道具id
//            "count":$count,       // 赠送数量
//            "appid":$appid,       // 业务id
//            "senderuid":$senderuid,    //赠送者uid
//            "senderimid":$senderimid,  //赠送者imid
//            "sendernickname":$sendernickname,  //赠送者昵称
//            "recveruid":$recveruid,    //主持人或房主uid
//            "recverimid":$recverimid,  //主持人或房主imid
//            "recvernickname":$recvernickname,  //主持人或房主昵称
//
//            // 真正接收者，可以是嘉宾，或者主持人、房主
//            "realRecveruid":$realRecveruid,    //真正接收者uid
//            "realRecverimid":$realRecverimid,      //真正接收者imid
//            "realRecvernickname":$realRecvernickname,      //真正接收者昵称
//
//            "expand":"$expand"    // 扩展字段，请求时expand字段原文
//    }

    private String seq;
    private long uid;
    private int result;
    private String message;
    private int propsId;
    private int count;
    private int appId;
    private long senderUid;
    private String sendernickname;
    private long recveruid;
    private String recvernickname;
    private long realRecveruid;
    private String realRecvernickname;
    private String expend;
    private String confirmUrl;
    private int buyCount;

    public UseItemResponse(String jsonMsg) {
        parserResponse(jsonMsg);
    }

    @Override
    public void parserResponse(String jsonMsg) {
        try {
            JSONObject resp = new JSONObject(jsonMsg);
            seq = resp.optString("seq", "");
            uid = resp.optLong("uid", 0);
            result = resp.optInt("result", -1);
            message = resp.optString("message", "");
            propsId = resp.optInt("propsId", 0);
            count = resp.optInt("count", 0);
            appId = resp.optInt("appId", 0);
            senderUid = resp.optLong("senderUid", 0);
            sendernickname = resp.optString("sendernickname", "");
            recveruid = resp.optLong("recveruid", 0);
            recvernickname = resp.optString("recvernickname", "");
            realRecveruid = resp.optLong("realRecveruid", 0);
            realRecvernickname = resp.optString("realRecvernickname", "");
            expend = resp.optString("expand", "");
            confirmUrl = resp.optString("confirmUrl", "");
            buyCount = resp.optInt("buyCount", 0);
        } catch (Exception e) {
            RLog.error("UseItemResponse", "parserResponse error.", e);
        }
    }

    public String getSeq() {
        return seq;
    }

    public long getUid() {
        return uid;
    }

    public int getResult() {
        return result;
    }

    public String getMessage() {
        return message;
    }

    public int getPropsId() {
        return propsId;
    }

    public int getCount() {
        return count;
    }

    public int getAppId() {
        return appId;
    }

    public long getSenderUid() {
        return senderUid;
    }

    public String getSendernickname() {
        return sendernickname;
    }

    public long getRecveruid() {
        return recveruid;
    }

    public String getRecvernickname() {
        return recvernickname;
    }

    public long getRealRecveruid() {
        return realRecveruid;
    }

    public String getRealRecvernickname() {
        return realRecvernickname;
    }

    public String getExpend() {
        return expend;
    }

    public String getConfirmUrl() {
        return confirmUrl;
    }

    public int getBuyCount() {
        return buyCount;
    }
}
