package com.yy.mobile.framework.revenuesdk.gift.protocol;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.protocolbase.IBaseJsonResponse;
import com.yy.mobile.framework.revenuesdk.gift.bean.GiftInfo;
import com.yy.mobile.framework.revenuesdk.gift.util.GiftListUtil;

import org.json.JSONObject;

import java.util.List;

/**
 * 获取礼物的respone，主要用于判断是否回调
 */
public class GetPropsResponse implements IBaseJsonResponse {

    private static final String TAG = "GetPropsResponse";

    private String seq;
    private long uid;
    private int result; // 业务错误码
    private String message; // 业务返回码信息说明

    public GetPropsResponse(String jsonMsg) {
        parserResponse(jsonMsg);
    }

    @Override
    public void parserResponse(String jsonMsg) {
        try {
            JSONObject response = new JSONObject(jsonMsg);
            seq = response.optString("seq", "");
            uid = response.optLong("uid", 0);
            result = response.optInt("result", -1);
            message = response.optString("message", "");
            RLog.info("GetPropsResponse", "parserResponse seq:" + seq + ",uid:" + uid);
        } catch (Exception e) {
            RLog.error("GetPropsByAppIdResponse", "parserResponse error.", e);
        }
    }

    public String getSeq() {
        return seq;
    }

    public long getUid() {
        return uid;
    }

    public int getResult() {
        return result;
    }

    public String getMessage() {
        return message;
    }
}

