package com.yy.mobile.framework.revenuesdk.gift;

import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by lhf on 2018/8/13.
 * <p>
 * YY.Inc
 */
public class GiftCacheInfo {

    public static final String KEY_USED_CHANNEL = "usedChannel";
    public static final String KEY_LIVE_CATEGORY_ID = "liveCategoryId";
    public static final String KEY_URL_PREFIX = "urlPreFix";
    public static final String KEY_MD5_HASH = "md5Hash";
    public static final String KEY_COMPRESS_DATA = "compressData";

    public int usedChannel;
    public int liveCategoryId;
    public String urlPreFix;
    public String md5Hash;
    public String compressData;

    public GiftCacheInfo() {
        reset();
    }

    public GiftCacheInfo(int usedChannel,
                         int liveCategoryId,
                         String urlPreFix,
                         String md5Hash,
                         String compressData) {
        this.usedChannel = usedChannel;
        this.liveCategoryId = liveCategoryId;
        this.urlPreFix = urlPreFix;
        this.md5Hash = md5Hash;
        this.compressData = compressData;
    }

    public void reset() {
        usedChannel = 0;
        liveCategoryId = 0;
        urlPreFix = "";
        md5Hash = "";
        compressData = "";
    }

    public String toJsonStr() {
        String jsonStr = "";
        try {
            JSONObject jb = new JSONObject();
            jb.put(KEY_USED_CHANNEL, usedChannel);
            jb.put(KEY_LIVE_CATEGORY_ID, liveCategoryId);
            jb.put(KEY_URL_PREFIX, urlPreFix);
            jb.put(KEY_MD5_HASH, md5Hash);
            jb.put(KEY_COMPRESS_DATA, compressData);
            jsonStr = jb.toString();
        } catch (JSONException e) {
            RLog.error("GiftCacheInfo", "toJsonStr error.", e);
        }
        RLog.debug("GiftCacheInfo", "toJsonStr result = %s", jsonStr);
        return jsonStr;
    }

    @Override
    public String toString() {
        return "GiftCacheInfo{" +
                "usedChannel=" + usedChannel +
                ", liveCategoryId=" + liveCategoryId +
                ", urlPreFix='" + urlPreFix + '\'' +
                ", md5Hash='" + md5Hash + '\'' +
                ", compressData='" + compressData + '\'' +
                '}';
    }

    public static GiftCacheInfo parseFromJson(String data) {
        GiftCacheInfo cacheInfo = new GiftCacheInfo();
        try {
            JSONObject jb = new JSONObject(data);
            cacheInfo.usedChannel = jb.optInt(GiftCacheInfo.KEY_USED_CHANNEL, 0);
            cacheInfo.liveCategoryId = jb.optInt(GiftCacheInfo.KEY_LIVE_CATEGORY_ID, 0);
            cacheInfo.urlPreFix = jb.optString(GiftCacheInfo.KEY_URL_PREFIX, "");
            cacheInfo.md5Hash = jb.optString(GiftCacheInfo.KEY_MD5_HASH, "");
            cacheInfo.compressData = jb.optString(GiftCacheInfo.KEY_COMPRESS_DATA, "");
        } catch (JSONException e) {
            RLog.error("GiftCacheInfo", "parseFromJson error.", e);
        }
        RLog.debug("GiftCacheInfo", "parseFromJson result: = %s", cacheInfo.toString());
        return cacheInfo;
    }
}
