package com.yy.mobile.framework.revenuesdk.payapi.payservice;

import android.app.Activity;
import android.support.annotation.NonNull;

import com.yy.mobile.framework.revenuesdk.baseapi.IResult;
import com.yy.mobile.framework.revenuesdk.payapi.IPayCallback;
import com.yy.mobile.framework.revenuesdk.payapi.PayType;
import com.yy.mobile.framework.revenuesdk.payapi.bean.ProductInfo;
import com.yy.mobile.framework.revenuesdk.payapi.bean.PurchaseInfo;
import com.yy.mobile.framework.revenuesdk.payapi.bean.SkuDetailInfo;

import java.util.List;

/**
 * Created by ouyangshaocong on 2018/8/1.
 */

@SuppressWarnings("javadoc")
public interface IPayMethod {

    /**
     * 判断是否支持
     *
     * @param act
     * @return true 支持,false 不支持
     */
    boolean isSupported(Activity act);

    /**
     * 请求支付
     *
     * @param act
     * @param info
     * @param payload
     * @param callback
     */
    void requestPay(Activity act, long uid, ProductInfo info, String payload,
                    boolean isSetAccountId, IPayCallback<PurchaseInfo> callback);

    /**
     * 请求支付
     *
     * @param act
     * @param productId
     * @param payload
     * @param callback
     */
    void requestPay(Activity act, long uid, String productId, String payload,
                    boolean isSetAccountId, IPayCallback<PurchaseInfo> callback);

    /**
     * 请求订阅
     *
     * @param act
     * @param productId
     * @param payload
     * @param callback
     */
    void requestSubscription(Activity act, long uid, String productId, String payload,
                             boolean isSetAccountId, IPayCallback<PurchaseInfo> callback);

    /**
     * 订阅升级
     *
     * @param act
     * @param uid
     * @param oldProductId
     * @param newProductId
     * @param prorationMode
     * @param payload
     * @param callback
     */
    void updateSubscription(Activity act, long uid, String oldProductId, String newProductId,
                            int prorationMode, String payload, boolean isSetAccountId,
                            IPayCallback<PurchaseInfo> callback);

    /**
     * 查询所有未完成的支付订单.
     *
     * @param act
     * @param iResult
     * @return
     */
    boolean hasHangPayJobs(Activity act, IResult<List<PurchaseInfo>> iResult);

    /**
     * 查询所有取消订阅但未失效订单
     *
     * @param act
     * @param iResult
     * @return
     */
    boolean hasHangSubscribeJobs(Activity act, IResult<List<PurchaseInfo>> iResult);

    /**
     * 查询所有取消订阅但未失效订单
     *
     * @param act
     * @param iResult
     * @return
     */
    boolean queryHistoryPurchaseBySkuType(@NonNull Activity act, String skuType,
                                          IResult<List<PurchaseInfo>> iResult);

    /**
     * 继续完成未完成的订单.
     */
    boolean doHangJob(@NonNull PurchaseInfo info, IResult<String> result);

    /**
     * 清除本地未消耗的订单
     *
     * @param type 该参数没用，因为只有消耗型商品才能消耗
     * @return
     */
    void clearHangPayJob(Activity act, int type, IResult<PurchaseInfo> iResult);

    /**
     * 根据productId查询历史订单.
     *
     * @param product
     * @param iResult
     * @return
     */
    boolean queryHistoryPurchaseByProductId(String product, IResult<PurchaseInfo> iResult);

    /**
     * 查询GP谷歌商品信息
     *
     * @param skusList
     * @param skuType  {SkuType.INAPP, SkuType.SUBS}
     * @return
     */
    boolean querySkuDetails(Activity act, List<String> skusList, String skuType,
                            IResult<List<SkuDetailInfo>> iResult);

    /**
     * 是否已经跳转到第三方的支付页面.
     *
     * @return
     */
    boolean isPayingStatus();

    /**
     * 业务app已经返回前台，通过这个方法回调通知sdk
     * （用于解决"支付页面关闭退出，但是谷歌sdk没有任何回调给业务"）
     *
     * @return
     */
    void appHasReturnToForegroud();

    /**
     * 微信支付回调.
     * 微信支付比较特别，因为WXPayEntryActivity放的路径
     * 需要跟APP的包名一样，所以WXPayEntryActivity不能放在
     * 中间件里面，只能放在了业务外面,所以业务在WXPayEntryActivity的onResp
     * 回调的时候需要回调下结果给中间件.
     *
     * @param code
     * @param msg
     */
    void onWxPayResult(int code, String msg);

    /**
     * 状态码
     */
    public enum Status {
        OK(0, "支付成功"),
        NOT_SUPPORT(-101, "当前不支持该种支付方式"),
        ERROR(-102, "支付错误"),
        UNKNOWN(-103, "未知错误");

        final int code;
        final String message;

        /**
         * 私有构造函数
         *
         * @param code
         * @param message
         */
        Status(int code, String message) {
            this.code = code;
            this.message = message;
        }

        /**
         * 返回对应错误码
         *
         * @param code
         * @return
         */
        public static Status valueOf(int code) {
            switch (code) {
                case 0:
                    return OK;
                case -101:
                    return NOT_SUPPORT;
                case -102:
                    return ERROR;
                case -103:
                    return UNKNOWN;
                default:
                    return UNKNOWN;
            }
        }

        /**
         * 返回错误码
         *
         * @return
         */
        public int getCode() {
            return code;
        }

        /**
         * 返回错误描述
         *
         * @return
         */
        public String getMessage() {
            return message;
        }
    }

}
