package com.yy.mobile.framework.revenuesdk.payapi.callbackresult;

import com.yy.mobile.framework.revenuesdk.baseapi.ErrorCode;

/**
 * Created by ouyangshaocong on 2018/7/18.
 */
public class PayOrderResult {
    final int result;
    final String payUrl;
    final String payChannel;
    final String orderId;
    final String payMethod;
    final String closeRiskEnhance;
    final String expand;

    /**
     * 构造函数
     *
     * @param result
     */
    public PayOrderResult(int result, String payUrl, String payChannel, String orderId,
                          String payMethod, String closeRiskEnhance, String expand) {
        this.result = result;
        this.payUrl = payUrl;
        this.payChannel = payChannel;
        this.orderId = orderId;
        this.payMethod = payMethod;
        this.closeRiskEnhance = closeRiskEnhance;
        this.expand = expand;
    }

    public int getResult() {
        return result;
    }

    public String getPayUrl() {
        return payUrl;
    }

    public String getPayChannel() {
        return payChannel;
    }

    public String getOrderId() {
        return orderId;
    }

    public String getPayMethod() {
        return payMethod;
    }

    public String getCloseRiskEnhance() {
        return closeRiskEnhance;
    }

    public boolean isSuccess() {
        return result == ErrorCode.SUCCESS;
    }

    public int getResultCode() {
        return result;
    }

    public String getExpand() {
        return expand;
    }

    @Override
    public String toString() {
        return "PayOrderResult{" +
                "result=" + result +
                ", payUrl='" + payUrl + '\'' +
                ", payChannel='" + payChannel + '\'' +
                ", orderId='" + orderId + '\'' +
                ", payMethod='" + payMethod + '\'' +
                ", expand='" + expand + '\'' +
                '}';
    }
}
