package com.yy.mobile.framework.revenuesdk.payapi.callbackresult;


import com.yy.mobile.framework.revenuesdk.payapi.bean.MyBalanceInfo;

/**
 * Created by lhf on 2018/7/9.
 * <p>
 * YY.Inc
 */
public class MyBalanceResult {
    private MyBalanceInfo myBalanceInfo;

    /**
     * 构造函数
     *
     * @param myBalanceInfo myBalanceInfo
     */
    public MyBalanceResult(MyBalanceInfo myBalanceInfo) {
        this.myBalanceInfo = myBalanceInfo;
    }

    /**
     * 获取余额
     *
     * @param type //货币类型
     * @return 账户信息
     */
    public MyBalanceInfo.Account getMyBalance(int type) {
        if (null == myBalanceInfo) {
            return new MyBalanceInfo.Account();
        }
        return myBalanceInfo.getMyBalance(type);
    }

    public MyBalanceInfo.AccountPeriod getMyAccountPeriod(int type) {
        if (null == myBalanceInfo) {
            return new MyBalanceInfo.AccountPeriod();
        }
        return myBalanceInfo.getMyAccountPeriod(type);
    }

}
