package com.yy.mobile.framework.revenuesdk.payapi.bean;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Created by ouyangshaocong on 2018/7/19.
 */
public class PurchaseInfo implements Parcelable {
    public final String data;
    public final String signature;

    /**
     * 构造函数
     */
    public PurchaseInfo() {
        this("", "");
    }

    /**
     * 构造函数
     *
     * @param data
     * @param signature
     */
    public PurchaseInfo(String data, String signature) {
        this.data = data;
        this.signature = signature;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.data);
        dest.writeString(this.signature);
    }

    protected PurchaseInfo(Parcel in) {
        this.data = in.readString();
        this.signature = in.readString();
    }

    @Override
    public String toString() {
        return "PurchaseInfo{" +
                "data='" + data + '\'' +
                ", signature='" + signature + '\'' +
                '}';
    }

    public static final Parcelable.Creator<PurchaseInfo> CREATOR =
            new Parcelable.Creator<PurchaseInfo>() {
                @Override
                public PurchaseInfo createFromParcel(Parcel source) {
                    return new PurchaseInfo(source);
                }

                @Override
                public PurchaseInfo[] newArray(int size) {
                    return new PurchaseInfo[size];
                }
            };
}
