package com.yy.mobile.framework.revenuesdk.payapi.bean;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by lhf on 2018/7/6.
 * <p>
 * YY.Inc
 */
public class ProductInfo {
    public int cid; //充值配置id，调用充值的时候，传入这个id
    public String offersTips; //每个充值列表的提示，如：优惠0%
    public String name; //配置名称，如Android-500元
    public int level; //排序权重，取值从0开始：0、1、2...
    public Double srcAmount; //金额（浮点类型）
    public String srcCurrencySymbol; //金额单位
    public long destAmount; //充值货币时，目标货币充值数量（整形）（没有相关赠送及优惠的原始值）
    public int offersType; //优惠类型，1-充值百分比赠送，2-充值固定赠送，3-打折
    public int offersRate; //赠送比例、赠送货币数量、打折优惠（整形，当offersType=(1,3)时，该值为百分比）
    //如果有套餐加金币的情况，就有出现下面两个字段，没有的话就没加金币，金币的数量看offersRate字段
    public boolean offers_currency_same; //是否是赠送同种货币
    public int offers_currency_type; //货币类型
    public String offers_currency_name; //货币名称
    public boolean hasAct; //是否有促销活动，true or false，只有当其为true，才可能有hasCurrencyAct、hasPropsAct
    //只有当有货币优惠活动，才会有出现此字段，才可能有hasDestCurrencyAct、hasOtherCurrencyAct
    public boolean hasCurrencyAct;
    //若活动优惠等赠送一定数额的该货币，则会出现以下三个字段（赠送的是相同类型的货币）
    public boolean hasDestCurrencyAct; //是否有目标货币优惠活动
    public long spAmount; //活动赠送的货币数量(包括首冲)
    public long spSumAmount; //充值原本得到的货币数量 与 活动赠送货币数量的总额
    //若活动优惠等赠送一定数额的其他货币，则会出现以下两个字段
    public boolean hasOtherCurrencyAct; //是否有其他货币优惠活动
    public int otherCurrenciesSum; //列表的个数
    public List<CurrencyInfo> otherCurrencies = new ArrayList<>();
    // 如果首冲赠送货币的话会出现以下两个字段
    public boolean hasFirstRush; //是否有首冲
    public long firstRushAmount; //首冲赠送的货币数
    //若活动优惠等赠送道具礼物，则会出现以下两个字段
    public boolean hasPropsAct; //是否有道具优惠活动
    public int propsSum; //列表个数
    public List<PropsInfo> props = new ArrayList<>(); //用列表保存道具信息
    public Double chargeRate; //充值的兑换率，srcAmount*chargeRate = destAmount
    public String productId; //IOS在appstore上扣费的产品ID 或者 Android在GoogleStore上的产品ID
    public String expand; //扩展字段

    public String currencyCode;
    public String otherPrice;

    public String payChannel;
    public String payMethod;
    public String subChannel;
    public String payType;
    public int usedChannelType;



    @Override
    public String toString() {
        return "ProductInfo{" +
                "cid=" + cid +
                ", offersTips='" + offersTips + '\'' +
                ", name='" + name + '\'' +
                ", level=" + level +
                ", srcAmount=" + srcAmount +
                ", srcCurrencySymbol=" + srcCurrencySymbol +
                ", destAmount=" + destAmount +
                ", offersType=" + offersType +
                ", offersRate=" + offersRate +
                ", offers_currency_same=" + offers_currency_same +
                ", offers_currency_type=" + offers_currency_type +
                ", offers_currency_name='" + offers_currency_name + '\'' +
                ", hasAct=" + hasAct +
                ", hasCurrencyAct=" + hasCurrencyAct +
                ", hasDestCurrencyAct=" + hasDestCurrencyAct +
                ", spAmount=" + spAmount +
                ", spSumAmount=" + spSumAmount +
                ", hasOtherCurrencyAct=" + hasOtherCurrencyAct +
                ", otherCurrenciesSum=" + otherCurrenciesSum +
                ", otherCurrencies=" + otherCurrencies +
                ", hasFirstRush=" + hasFirstRush +
                ", firstRushAmount=" + firstRushAmount +
                ", hasPropsAct=" + hasPropsAct +
                ", propsSum=" + propsSum +
                ", props=" + props +
                ", chargeRate=" + chargeRate +
                ", productId='" + productId + '\'' +
                ", expand=" + expand +
                ", currencyCode=" + currencyCode +
                ", otherPrice=" + otherPrice +
                ", payChannel=" + payChannel +
                ", payMethod=" + payMethod +
                ", subChannel=" + subChannel +
                ", payType=" + payType +
                ", usedChannelType=" + usedChannelType +
                '}';
    }
}
