package com.yy.mobile.framework.revenuesdk.payapi.bean;

import java.util.Map;

/**
 * Created by lhf on 2018/7/5.
 * <p>
 * YY.Inc
 */
public class MyBalanceInfo {
    // key 为对应货币类型
    private Map<Integer, Account> myBalanceMap;

    private Map<Integer, AccountPeriod> myAccountPeriodMap;

    private long minAmountLimit;

    /**
     * 构造函数
     *
     * @param myBalanceMap
     */
    public MyBalanceInfo(Map<Integer, Account> myBalanceMap,
                         Map<Integer, AccountPeriod> myAccountPeriodMap, long minAmountLimit) {
        this.myBalanceMap = myBalanceMap;
        this.myAccountPeriodMap = myAccountPeriodMap;
        this.minAmountLimit = minAmountLimit;
    }

    /**
     * 获取余额
     *
     * @param type
     * @return
     */
    public Account getMyBalance(int type) {
        if (null == myBalanceMap || !myBalanceMap.containsKey(type)) {
            return new Account();
        }
        return myBalanceMap.get(type);
    }

    public AccountPeriod getMyAccountPeriod(int type) {
        if (null == myAccountPeriodMap || !myAccountPeriodMap.containsKey(type)) {
            return new AccountPeriod();
        }
        return myAccountPeriodMap.get(type);
    }

    public long getMinAmountLimit() {
        return minAmountLimit;
    }

    @Override
    public String toString() {
        return "MyBalanceInfo{" +
                "myBalanceMap=" + myBalanceMap +
                "minAmountLimit=" + minAmountLimit +
                '}';
    }

    public static class Account {
        public int currencyType; // 账户货币类型
        public long amount; // 可用余额
        public long freezed; // 被冻结余额，实际可用为amount-freezed
        public int accountFrozen; // 账户是否冻结，0-未冻结，1-已冻结
        public long expireAmount; // 即将在expireDate过期的数量
        public String expireDate; // 即将过期的时间

        @Override
        public String toString() {
            return "Account{" +
                    "currencyType=" + currencyType +
                    ", amount=" + amount +
                    ", freezed=" + freezed +
                    ", accountFrozen=" + accountFrozen +
                    ", expireAmount = " + expireAmount +
                    ", expireDate = " + expireDate +
                    '}';
        }
    }

    public static class AccountPeriod {
        public int currencyType; // 有效期货币类型
        public int amount; // 有效期货币余额
        public long startTime; //有效期开始时间
        public long endTime; //有效期结束时间

        @Override
        public String toString() {
            return "AccountPeriod{" +
                    "currencyType=" + currencyType +
                    ", amount=" + amount +
                    ", startTime=" + startTime +
                    ", endTime=" + endTime +
                    '}';
        }
    }

}
