package com.yy.mobile.framework.revenuesdk.payapi;

import android.app.Activity;
import android.app.Application;

import com.yy.mobile.framework.revenuesdk.baseapi.IResult;
import com.yy.mobile.framework.revenuesdk.baseapi.log.RLog;
import com.yy.mobile.framework.revenuesdk.baseapi.utils.ThreadPool;
import com.yy.mobile.framework.revenuesdk.payapi.bean.PurchaseInfo;
import com.yy.mobile.framework.revenuesdk.payapi.bean.PurchaseStatusInfo;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

/**
 * 购买订单状态处理
 */
public class PurchaseStatusImpl {

    private static final String SAVE_FILE_DIR = "PurchaseStatus";   // 缓存目录
    private static final String PURCHASE_PRODUCTID = "productid";
    private static final String PURCHASE_ORDERID = "orderid";
    private static final String PURCHASE_CHORDERID = "chorderid";
    private static final String PURCHASE_STATUS = "status";
    private static final String PURCHASE_UID = "uid";
    private static final String PURCHASE_DATA = "data";
    private static final String PURCHASE_SIGN = "sign";
    public static final String TAG = "PurchaseStatusUtils";

    /**
     * 保存订单信息
     *
     * @param activity
     * @param purchaseStatusInfo
     */
    public static void savePurchaseStatus(Activity activity,
                                          final PurchaseStatusInfo purchaseStatusInfo) {

        if (activity == null) {
            RLog.error(TAG, "save purchaseStatus fail err: %d", "activity == null");
            return;
        }
        final Application application = activity.getApplication();

        if (application == null || application.getCacheDir() == null) {
            RLog.error(TAG, "save purchaseStatus fail err: %d",
                    "application == null || application.getCacheDir() == null");
            return;
        }

        if (purchaseStatusInfo.productId == null || purchaseStatusInfo.orderId == null) {
            RLog.error(TAG, "save purchaseStatus fail err: %d", "productId == null || orderId == " +
                    "null");
            return;
        }
        ThreadPool.getDefault().diskIO().execute(new Runnable() {
            @Override
            public void run() {
                String fileName =
                        purchaseStatusInfo.productId + purchaseStatusInfo.orderId +
                                purchaseStatusInfo.uid + ".info";
                String path =
                        application.getCacheDir().getAbsolutePath() + File.separator +
                                SAVE_FILE_DIR + File.separator;
                File filedir = new File(path);
                if (!filedir.exists()) {
                    filedir.mkdir();   // 如果不存在先创建目录
                    try {
                        filedir.createNewFile();
                    } catch (IOException e) {
                        RLog.info(TAG,
                                "save purchaseStatus--filedir---createNewFile fail: " +
                                        e.getMessage());
                        e.printStackTrace();
                    }
                }
                File file = new File(path + fileName);
                if (file.exists()) {
                    file.delete();  //先删除，重新创建
                }
                if (!file.isFile()) {
                    try {
                        file.createNewFile();
                    } catch (IOException e) {
                        RLog.info(TAG, "save purchaseStatus--file --- createNewFile fial: " +
                                e.getMessage());
                        e.printStackTrace();
                    }
                }

                Properties properties = new Properties();
                properties.setProperty(PURCHASE_PRODUCTID, purchaseStatusInfo.productId);
                properties.setProperty(PURCHASE_ORDERID, purchaseStatusInfo.orderId);
                if (purchaseStatusInfo.chorderid != null) {
                    properties.setProperty(PURCHASE_CHORDERID, purchaseStatusInfo.chorderid);
                } else {
                    properties.setProperty(PURCHASE_CHORDERID, "");
                }
                properties.setProperty(PURCHASE_STATUS, String.valueOf(purchaseStatusInfo.status));
                properties.setProperty(PURCHASE_UID, String.valueOf(purchaseStatusInfo.uid));

                if (purchaseStatusInfo.purchaseData != null) {
                    properties.setProperty(PURCHASE_DATA, purchaseStatusInfo.purchaseData);
                } else {
                    properties.setProperty(PURCHASE_DATA, "");
                }
                if (purchaseStatusInfo.purchaseSign != null) {
                    properties.setProperty(PURCHASE_SIGN, purchaseStatusInfo.purchaseSign);
                } else {
                    properties.setProperty(PURCHASE_SIGN, "");
                }

                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(file);
                    properties.store(fos, "PurchaseStatusUtils");
                    RLog.info(TAG, "purchaseStatus -- save purchaseStatus success ");
                } catch (Exception e) {
                    RLog.error(TAG, "purchaseStatus --  save purchaseStatus fail err: %d",
                            e.getMessage());
                } finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        } catch (IOException e) {
                            RLog.error(TAG, "purchaseStatus -- close FileOutputStream fail err: %d",
                                    e.getMessage());
                        }
                    }
                }
            }
        });
    }

    /**
     * 读取单个订单下的信息
     *
     * @param activity
     * @param productId
     * @param uid
     * @param orderId
     * @param iResult
     */
    public static void readPurchaseStatus(Activity activity, String productId,
                                          String uid, String orderId,
                                          IResult<PurchaseStatusInfo> iResult) {

        if (activity == null) {
            RLog.error(TAG, "read purchaseStatus fail err: %d", "activity == null");
            iResult.onFail(-1, "read purchaseStatus fail err: activity == null",
                    null);
            return;
        }
        final Application application = activity.getApplication();

        if (application == null || application.getCacheDir() == null) {
            RLog.error(TAG, "read purchaseStatus fail err: %d",
                    "application == null || application.getCacheDir() == null");
            iResult.onFail(-1, "read purchaseStatus fail err: application == null " +
                    "|| application.getCacheDir() == null", null);
            return;

        }
        String fileName = productId + orderId + uid + ".info";
        String path =
                application.getCacheDir().getAbsolutePath() + File.separator +
                        SAVE_FILE_DIR + File.separator;

        File file = new File(path + fileName);
        if (!file.exists() || !file.canRead()) {
            RLog.error(TAG, "read PurchaseStatus fail， file not exist or file can't read");
            iResult.onFail(-1, "read PurchaseStatus fail ，file exist or file can't read",
                    null);
            return;
        }

        Properties properties = new Properties();
        FileInputStream fos = null;
        try {
            fos = new FileInputStream(file);
            properties.load(fos);
            PurchaseStatusInfo info = new PurchaseStatusInfo();
            info.productId = properties.getProperty(PURCHASE_PRODUCTID);
            info.uid = Long.valueOf(properties.getProperty(PURCHASE_UID));
            info.orderId = properties.getProperty(PURCHASE_ORDERID);
            info.chorderid = properties.getProperty(PURCHASE_CHORDERID);
            info.status = Integer.valueOf(properties.getProperty(PURCHASE_STATUS));
            info.purchaseData = properties.getProperty(PURCHASE_DATA);
            info.purchaseSign = properties.getProperty(PURCHASE_SIGN);

            iResult.onSuccess(info, null);
        } catch (Exception e) {
            RLog.error(TAG, "read PurchaseStatus fail err: %d", e.getMessage());
            iResult.onFail(-1, "close PurchaseStatus fail:" + e.getMessage(),
                    null);
        } finally {
            if (fos != null) {
                try {
                    fos.close();
                } catch (IOException e) {
                    RLog.error(TAG, "close PurchaseStatus fail err: %d", e.getMessage());
                    iResult.onFail(-1, "close PurchaseStatus fail",
                            null);
                }
            }
        }
    }

    /**
     * 读取缓存下的所有订单信息
     *
     * @param activity
     * @param iResult
     */
    public static void readAllPurchaseStatus(Activity activity,
                                             IResult<List<PurchaseStatusInfo>> iResult) {
        if (activity == null) {
            RLog.error(TAG, "read purchaseStatus fail err: %d", "activity == null");
            iResult.onFail(-1, "read purchaseStatus fail err: activity == null",
                    null);
            return;
        }
        final Application application = activity.getApplication();

        if (application == null || application.getCacheDir() == null) {
            RLog.error(TAG, "read purchaseStatus fail err: %d",
                    "application == null || application.getCacheDir() == null");
            iResult.onFail(-1, "read purchaseStatus fail err: application == null " +
                    "|| application.getCacheDir() == null", null);
            return;
        }


        String path =
                application.getCacheDir().getAbsolutePath() + File.separator +
                        SAVE_FILE_DIR + File.separator;
        File pathDir = new File(path);
        if (!pathDir.isDirectory()) {
            RLog.error(TAG, "read all purchaseStatus fail， err: %d",
                    "pathDir is null path");
            iResult.onFail(-1, "read all purchaseStatus fail，err: pathDir is not path", null);
            return;
        }
        File[] files = pathDir.listFiles();
        List<PurchaseStatusInfo> purchaseStatusInfoList = new ArrayList<PurchaseStatusInfo>();

        if (files == null) {
            iResult.onSuccess(purchaseStatusInfoList, null);
            return;
        }

        for (File file : files) {
            if (file.isDirectory() || !file.exists() || !file.canRead()) {
                RLog.error(TAG, "read all PurchaseStatus fail， file no exist or file can't read");
                continue;
            }
            Properties properties = new Properties();
            FileInputStream fos = null;
            try {
                fos = new FileInputStream(file);
                properties.load(fos);
                PurchaseStatusInfo info = new PurchaseStatusInfo();
                info.productId = properties.getProperty(PURCHASE_PRODUCTID);
                info.uid = Long.valueOf(properties.getProperty(PURCHASE_UID));
                info.orderId = properties.getProperty(PURCHASE_ORDERID);
                info.chorderid = properties.getProperty(PURCHASE_CHORDERID);
                info.status = Integer.valueOf(properties.getProperty(PURCHASE_STATUS));
                info.purchaseData = properties.getProperty(PURCHASE_DATA);
                info.purchaseSign = properties.getProperty(PURCHASE_SIGN);
                purchaseStatusInfoList.add(info);
            } catch (Exception e) {
                RLog.error(TAG, "read all PurchaseStatus fail， err: %d", e.getMessage());
            } finally {
                if (fos != null) {
                    try {
                        fos.close();
                    } catch (IOException e) {
                        RLog.error(TAG, "read all PurchaseStatus fail， fail err: %d",
                                e.getMessage());
                    }
                }
            }
        }
        iResult.onSuccess(purchaseStatusInfoList, null);
    }

    /**
     * 删除某个缓存订单信息
     *
     * @param activity
     * @param productId
     * @param uid
     * @param orderId
     */
    public static void deletePurchaseStatus(Activity activity, final String productId,
                                            final long uid, final String orderId) {

        if (activity == null) {
            RLog.error(TAG, "delete purchaseStatus fai, err: %d", "activity == null");
            return;
        }
        final Application application = activity.getApplication();

        if (application == null || application.getCacheDir() == null) {
            RLog.error(TAG, "delete purchaseStatus fail, err: %d",
                    "application == null || application.getCacheDir() == null");
            return;
        }

        ThreadPool.getDefault().diskIO().execute(new Runnable() {
            @Override
            public void run() {
                String fileName = productId + orderId + uid + ".info";
                String path =
                        application.getCacheDir().getAbsolutePath() + File.separator +
                                SAVE_FILE_DIR + File.separator;
                File file = new File(path + fileName);
                if (file.exists()) {
                    if (file.delete()) {
                        RLog.info(TAG, "delete PurchaseStatus info success");
                    } else {
                        RLog.info(TAG, "delete PurchaseStatus info fail");
                    }
                } else {
                    RLog.info(TAG, "delete PurchaseStatus info fail, file not found");
                }
            }
        });
    }

    /**
     * 删除所有缓存订单信息
     *
     * @param activity
     */
    public static void deleteAllPurchaseStatus(Activity activity) {

        if (activity == null) {
            RLog.error(TAG, "delete all purchaseStatus fail err: %d", "activity == null");
            return;
        }
        final Application application = activity.getApplication();

        if (application == null || application.getCacheDir() == null) {
            RLog.error(TAG, "delete all purchaseStatus fail err: %d",
                    "application == null || application.getCacheDir() == null");
            return;
        }

        ThreadPool.getDefault().diskIO().execute(new Runnable() {
            @Override
            public void run() {

                String path =
                        application.getCacheDir().getAbsolutePath() + File.separator +
                                SAVE_FILE_DIR + File.separator;

                File pathDir = new File(path);
                if (!pathDir.isDirectory()) {
                    RLog.error(TAG, "delete all purchaseStatus fail, err: %d",
                            "pathDir is null path");
                    return;
                }
                File[] files = pathDir.listFiles();

                for (File file : files) {
                    if (file.exists()) {
                        if (file.delete()) {
                            RLog.info(TAG, "delete all purchaseStatus info success");
                        } else {
                            RLog.info(TAG, "delete all purchaseStatus info fail");
                        }
                    } else {
                        RLog.info(TAG, "delete all purchaseStatus info fail, file not found");
                    }
                }
            }
        });
    }

    public static String getCHOrderId(String payload) {
        String chOrderId = "";
        try {
            JSONObject jsonObject = new JSONObject(payload);
            chOrderId = jsonObject.optString("chOrderId");
        } catch (JSONException e) {
            RLog.error(TAG, "getOrderId fail raw str: %s, err msg: %s", payload, e.getMessage());
        }
        return chOrderId;
    }

}
