package com.yy.mobile.framework.revenuesdk.payapi;

/**
 * Created by lhf on 2018/7/5.
 * <p>
 * YY.Inc
 */
public enum PayStatus {
    OK(1, "请求成功"),
    VALIDATE_FAIL(-1, "账号验证失败"),
    CAN_NOT_USE(-5, "账户已冻结"),
    APPLE_PAY_FAIL(-14, "苹果支付凭证重复验证"),
    WRONG_ARGS(-400, "参数错误，特指参数缺失"),
    SEVER_ERROR(-500, "服务端错误"),
    ORDER_RISK_ERROR(-18, "风控拦截"),
    UNKNOWN(0, "未知状态");

    final int code;
    final String msg;

    /**
     * 构造函数
     *
     * @param code
     * @param msg
     */
    PayStatus(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    /**
     * 判断code，获取指定状态
     *
     * @param code
     */
    public static PayStatus valueOf(int code) {
        switch (code) {
            case 1:
                return OK;
            case -1:
                return VALIDATE_FAIL;
            case -5:
                return CAN_NOT_USE;
            case -14:
                return APPLE_PAY_FAIL;
            case -400:
                return WRONG_ARGS;
            case -500:
                return SEVER_ERROR;
            case -18:
                return ORDER_RISK_ERROR;
            default:
                return UNKNOWN;
        }
    }

    /**
     * 返回状态码
     *
     * @return
     */
    public int getCode() {
        return code;
    }

    /**
     * 返回状态信息
     *
     * @return
     */
    public String getMessage() {
        return msg;
    }
}
