/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.shenqu.tanmu;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import com.yy.mobile.YYMobileApp;
import com.yy.mobile.richtext.EmoticonFilter;
import com.yy.mobile.ui.shenqu.tanmu.GunPowder;
import com.yy.mobile.util.DimenConverter;
import com.yy.mobile.util.log.MLog;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ShellBuilder {
    private static final String TAG = "ShellBuilder";
    public int mAvatarBorderWidth;
    private AtomicInteger mRange = null;
    private Paint mStoke2Painter = null;
    private Paint mPainter = null;
    private Paint mStokePainter = null;
    private Paint mCountPainter = null;
    private Paint mCountTextPainter = null;
    private Paint mAvatarPaint;
    private Paint mAvatarBorderPaint;
    private Paint mVideoBorderPaint;
    private Paint mBackgroundPaint;
    private final Matrix mShaderMatrix = new Matrix();
    private Canvas mCanvas = null;
    private AtomicBoolean mLocker = new AtomicBoolean(true);
    private Rect powerAvatarRect = new Rect();
    private RectF powerBackgroundRectF = new RectF();
    DanmuType mCurrentDanmuType = DanmuType.common;

    public void setCurruntDanmuType(DanmuType type) {
        this.mCurrentDanmuType = type;
        if (this.mPainter != null) {
            if (type == DanmuType.common) {
                this.mPainter.setShadowLayer(2.0f, 3.0f, 3.0f, 0x5A000000);
            } else if (type == DanmuType.noble) {
                this.mPainter.setShadowLayer((float)DimenConverter.sp2px((Context)YYMobileApp.gContext, (float)3.0f), (float)DimenConverter.sp2px((Context)YYMobileApp.gContext, (float)3.0f), (float)DimenConverter.sp2px((Context)YYMobileApp.gContext, (float)2.0f), 0x5A000000);
            } else if (type == DanmuType.avatar) {
                this.mPainter.setShadowLayer(2.0f, 0.0f, 1.0f, 0x42000000);
            }
        }
    }

    public ShellBuilder(int range) {
        this.mRange = new AtomicInteger(range);
        this.initPainter();
        this.initStoke2Painter();
        this.initCountTextPainter();
        this.initCountPainter();
        this.initStokePainter();
        this.initAvatarPaint();
        this.initVideoBorderPaint();
        this.initCanvas();
    }

    private void initPainter() {
        this.mPainter = new Paint(1);
        this.mPainter.setTextSize((float)DimenConverter.sp2px((Context)YYMobileApp.gContext, (float)18.0f));
        this.mPainter.setColor(-1);
        this.mPainter.setTextAlign(Paint.Align.LEFT);
        this.mPainter.setShadowLayer(2.0f, 3.0f, 3.0f, 0x5A000000);
    }

    private void initStoke2Painter() {
        this.mStoke2Painter = new Paint(1);
        this.mStoke2Painter.setTextSize((float)DimenConverter.sp2px((Context)YYMobileApp.gContext, (float)18.0f));
        this.mStoke2Painter.setColor(-6710887);
        this.mStoke2Painter.setStyle(Paint.Style.STROKE);
        this.mStoke2Painter.setTextAlign(Paint.Align.LEFT);
    }

    private void initCountTextPainter() {
        this.mCountTextPainter = new Paint(1);
        this.mCountTextPainter.setTextSize((float)DimenConverter.sp2px((Context)YYMobileApp.gContext, (float)18.0f));
        this.mCountTextPainter.setColor(-1);
        this.mCountTextPainter.setTextAlign(Paint.Align.LEFT);
        this.mCountTextPainter.setShadowLayer(2.0f, 3.0f, 3.0f, 0x5A000000);
    }

    private void initCountPainter() {
        this.mCountPainter = new Paint(1);
        this.mCountPainter.setTextSize((float)DimenConverter.sp2px((Context)YYMobileApp.gContext, (float)16.0f));
        this.mCountPainter.setColor(-1);
        this.mCountPainter.setTextAlign(Paint.Align.LEFT);
        this.mCountPainter.setShadowLayer(2.0f, 3.0f, 3.0f, 0x5A000000);
    }

    private void initStokePainter() {
        this.mStokePainter = new Paint(1);
        this.mStokePainter.setTextSize((float)DimenConverter.sp2px((Context)YYMobileApp.gContext, (float)16.0f));
        this.mStokePainter.setColor(-16726073);
        this.mStokePainter.setStrokeWidth(2.0f);
        this.mStokePainter.setStyle(Paint.Style.STROKE);
        this.mStokePainter.setTextAlign(Paint.Align.LEFT);
    }

    private void initAvatarPaint() {
        this.mAvatarPaint = new Paint(1);
        this.mBackgroundPaint = new Paint(1);
        this.mAvatarBorderPaint = new Paint(1);
        this.mAvatarBorderPaint.setStyle(Paint.Style.STROKE);
        this.mAvatarBorderPaint.setAntiAlias(true);
        this.mAvatarBorderPaint.setColor(-1);
        this.mAvatarBorderWidth = DimenConverter.dip2px((Context)YYMobileApp.gContext, (float)1.0f);
        this.mAvatarBorderPaint.setStrokeWidth((float)this.mAvatarBorderWidth);
    }

    private void initVideoBorderPaint() {
        this.mVideoBorderPaint = new Paint(1);
        this.mVideoBorderPaint.setStyle(Paint.Style.STROKE);
        this.mVideoBorderPaint.setAntiAlias(true);
        this.mVideoBorderPaint.setColor(-555513041);
        this.mVideoBorderPaint.setStrokeWidth((float)DimenConverter.dip2px((Context)YYMobileApp.gContext, (float)1.0f));
    }

    private Bitmap zoom(Bitmap oriBmp, int dstWidth, int dstHeight) {
        int width = oriBmp.getWidth();
        int height = oriBmp.getHeight();
        float scaleWidth = (float)dstWidth / (float)width;
        float scaleHeight = (float)dstHeight / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        return Bitmap.createBitmap((Bitmap)oriBmp, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
    }

    private void initCanvas() {
        this.mCanvas = new Canvas();
    }

    public synchronized Shell gunPowderToShell(GunPowder ammo) {
        Shell shell = new Shell();
        if (this.mLocker.get()) {
            this.mLocker.set(false);
            this.mPainter.setTextSize((float)DimenConverter.sp2px((Context)YYMobileApp.gContext, (float)ammo.mTextSize));
            int width = 0;
            int height = 0;
            int textHeight = 0;
            int giftHeight = 0;
            int giftWidth = 0;
            width = (int)(this.mPainter.measureText(ammo.mPowder) + 0.5f);
            float baseline = (int)(-this.mPainter.ascent() + 0.5f);
            height = (int)(baseline + this.mPainter.descent() + 0.5f);
            if (width <= 0) {
                width = 120;
            }
            if (height <= 0) {
                height = 45;
            }
            textHeight = height;
            try {
                float radius;
                int w = 0;
                if (ammo.mIconList != null && ammo.mIconList.size() > 0) {
                    for (int i = 0; i < ammo.mIconList.size(); ++i) {
                        Bitmap bitmap = ammo.mIconList.get(i);
                        w += bitmap.getWidth() + 5;
                        height = Math.max(height, bitmap.getHeight());
                    }
                }
                int avatarWidth = 0;
                int avatarHeight = 0;
                int offsetLeft = 0;
                int offsetRight = 0;
                int textPosition = 0;
                if (ammo.mAvatarMode || ammo.mType == GunPowder.TYPE_SHORT_VIDEO) {
                    avatarHeight = DimenConverter.dip2px((Context)YYMobileApp.gContext, (float)24.0f);
                    avatarWidth = DimenConverter.dip2px((Context)YYMobileApp.gContext, (float)24.0f);
                    offsetLeft = DimenConverter.dip2px((Context)YYMobileApp.gContext, (float)8.0f);
                    offsetRight = DimenConverter.dip2px((Context)YYMobileApp.gContext, (float)12.0f);
                    if (ammo.mType == GunPowder.TYPE_SHORT_VIDEO) {
                        avatarHeight = DimenConverter.dip2px((Context)YYMobileApp.gContext, (float)16.0f);
                        offsetRight = offsetLeft;
                    }
                    textPosition = (avatarHeight - height) / 2;
                    height = avatarHeight;
                }
                if (ammo.mGiftMode) {
                    avatarHeight = DimenConverter.dip2px((Context)YYMobileApp.gContext, (float)24.0f);
                    avatarWidth = DimenConverter.dip2px((Context)YYMobileApp.gContext, (float)24.0f);
                    giftHeight = DimenConverter.dip2px((Context)YYMobileApp.gContext, (float)36.0f);
                    giftWidth = DimenConverter.dip2px((Context)YYMobileApp.gContext, (float)36.0f);
                    offsetLeft = DimenConverter.dip2px((Context)YYMobileApp.gContext, (float)8.0f);
                    offsetRight = DimenConverter.dip2px((Context)YYMobileApp.gContext, (float)12.0f);
                    textPosition = (avatarHeight - height) / 2;
                    height = avatarHeight;
                    w = giftWidth;
                }
                float len = EmoticonFilter.getInstance().measureWidth((Context)YYMobileApp.gContext, ammo.mPowder, 0.0f, baseline, width, textHeight, this.mPainter, ammo.mAvatar != null ? 1 : 2);
                int actualWidth = (int)(len + (float)w + (float)avatarWidth + (float)offsetLeft + (float)offsetRight);
                if (ammo.mType == GunPowder.TYPE_SHORT_VIDEO) {
                    actualWidth -= avatarWidth;
                }
                shell.mBitmap = ammo.mGiftMode ? Bitmap.createBitmap((int)actualWidth, (int)giftHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)actualWidth, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                this.mCanvas.setBitmap(shell.mBitmap);
                if (ammo.mAvatarMode && ammo.mAvatar != null || ammo.mType == GunPowder.TYPE_SHORT_VIDEO) {
                    this.mBackgroundPaint.setColor(ammo.mBackgroundColor);
                    radius = (float)height / 2.0f;
                    this.powerBackgroundRectF.set(0.0f, 0.0f, (float)actualWidth, (float)height);
                    this.mCanvas.drawRoundRect(this.powerBackgroundRectF, radius, radius, this.mBackgroundPaint);
                    if (ammo.mType == GunPowder.TYPE_DEFAULT) {
                        this.powerAvatarRect.set(0, 0, avatarWidth, avatarHeight);
                        BitmapShader shader = new BitmapShader(ammo.mAvatar, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
                        this.updateShaderMatrix(shader, ammo.mAvatar.getWidth(), ammo.mAvatar.getHeight(), this.powerAvatarRect);
                        this.mAvatarPaint.setShader((Shader)shader);
                        this.mCanvas.drawCircle((float)(avatarWidth / 2), (float)(avatarHeight / 2), (float)(avatarHeight / 2), this.mAvatarPaint);
                        this.mCanvas.drawCircle((float)(avatarWidth / 2), (float)(avatarHeight / 2), (float)((avatarHeight - this.mAvatarBorderWidth) / 2), this.mAvatarBorderPaint);
                    }
                }
                this.mPainter.setColor(ammo.mColor);
                if (ammo.mGiftMode && ammo.mGiftIcon != null && ammo.mAvatar != null) {
                    this.mBackgroundPaint.setColor(ammo.mBackgroundColor);
                    radius = (float)height / 2.0f;
                    int deltaHeight = (giftHeight - height) / 2;
                    String[] outPutStr = ammo.mPowder.split(":");
                    this.powerBackgroundRectF.set(0.0f, (float)deltaHeight, (float)actualWidth, (float)(height + deltaHeight));
                    this.mCanvas.drawRoundRect(this.powerBackgroundRectF, radius, radius, this.mBackgroundPaint);
                    this.mCanvas.save();
                    this.mCanvas.translate(0.0f, (float)deltaHeight);
                    this.powerAvatarRect.set(0, 0, avatarWidth, avatarHeight);
                    BitmapShader shader = new BitmapShader(ammo.mAvatar, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
                    this.updateShaderMatrix(shader, ammo.mAvatar.getWidth(), ammo.mAvatar.getHeight(), this.powerAvatarRect);
                    this.mAvatarPaint.setShader((Shader)shader);
                    this.mCanvas.drawCircle((float)(avatarWidth / 2), (float)(avatarHeight / 2), (float)(avatarHeight / 2), this.mAvatarPaint);
                    this.mCanvas.drawCircle((float)(avatarWidth / 2), (float)(avatarHeight / 2), (float)((avatarHeight - this.mAvatarBorderWidth) / 2), this.mAvatarBorderPaint);
                    this.mCanvas.restore();
                    Bitmap giftBmp = this.zoom(ammo.mGiftIcon, giftWidth, giftHeight);
                    int save = this.mCanvas.save();
                    this.mCanvas.translate((float)(offsetLeft + avatarWidth), 0.0f);
                    this.mPainter.setColor(-555513041);
                    int posX = 0;
                    this.mCanvas.drawText(outPutStr[0], (float)posX, (float)textPosition + baseline + (float)deltaHeight, this.mPainter);
                    posX = (int)((float)posX + (this.mPainter.measureText(outPutStr[0]) + 5.0f));
                    this.mCanvas.drawBitmap(giftBmp, (float)posX, 0.0f, this.mPainter);
                    this.mCanvas.drawText(outPutStr[1], (float)(posX += giftWidth + 5), (float)textPosition + baseline + (float)deltaHeight, this.mPainter);
                    this.mCanvas.restoreToCount(save);
                } else if (ammo.mIconList != null && ammo.mIconList.size() > 0) {
                    int posX = 0;
                    for (int j = 0; j < ammo.mIconList.size(); ++j) {
                        this.mCanvas.drawBitmap(ammo.mIconList.get(j), (float)posX, 0.0f, this.mPainter);
                        posX += ammo.mIconList.get(j).getWidth() + 5;
                    }
                    this.mCanvas.drawText(ammo.mPowder, (float)posX, baseline, this.mPainter);
                } else {
                    int save = this.mCanvas.save();
                    int translateDx = offsetLeft + avatarWidth;
                    if (ammo.mType == GunPowder.TYPE_SHORT_VIDEO) {
                        translateDx = offsetLeft;
                    }
                    this.mCanvas.translate((float)translateDx, (float)textPosition);
                    EmoticonFilter.getInstance().parseToBitmap((Context)YYMobileApp.gContext, this.mCanvas, ammo.mPowder, 0.0f, baseline, (int)len, textHeight, this.mPainter, ammo.mAvatar != null ? 1 : 2);
                    this.mCanvas.restoreToCount(save);
                }
            }
            catch (Throwable e) {
                MLog.error((Object)TAG, (String)e.toString(), (Throwable)e, (Object[])new Object[0]);
            }
            shell.mDuration = ammo.mDuration;
            shell.mIsMySelf = ammo.mIsMyself;
            this.mLocker.set(true);
        }
        return shell;
    }

    private void updateShaderMatrix(BitmapShader bitmapShader, int bitmapWidth, int bitmapHeight, Rect drawableRect) {
        float scale;
        float dx = 0.0f;
        float dy = 0.0f;
        this.mShaderMatrix.set(null);
        if (bitmapWidth * drawableRect.height() > drawableRect.width() * bitmapHeight) {
            scale = (float)drawableRect.height() / (float)bitmapHeight;
            dx = ((float)drawableRect.width() - (float)bitmapWidth * scale) * 0.5f;
        } else {
            scale = (float)drawableRect.width() / (float)bitmapWidth;
            dy = ((float)drawableRect.height() - (float)bitmapHeight * scale) * 0.5f;
        }
        this.mShaderMatrix.setScale(scale, scale);
        bitmapShader.setLocalMatrix(this.mShaderMatrix);
    }

    private void drawRichText(Canvas canvas, GunPowder ammo) {
        String text = ammo.mPowder;
    }

    public int getRange() {
        return this.mRange.get();
    }

    public void setRange(int range) {
        this.mRange.set(range);
    }

    public static class Shell {
        public Bitmap mBitmap;
        public int mDuration;
        public boolean mIsMySelf;
    }

    public static enum DanmuType {
        common,
        noble,
        avatar;

    }
}

