/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TabWidget;
import android.widget.TextView;
import com.yy.mobile.plugin.pluginunionmain.R;

public class BadgeView
extends TextView {
    private boolean mHideOnNull = true;
    private boolean mIsShow = true;

    public BadgeView(Context context) {
        this(context, null);
    }

    public BadgeView(Context context, AttributeSet attrs) {
        this(context, attrs, 16842884);
    }

    public BadgeView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        if (!(this.getLayoutParams() instanceof FrameLayout.LayoutParams)) {
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2, 53);
            this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        this.setId(R.id.red_dot);
        this.setTextColor(-1);
        this.setTypeface(Typeface.DEFAULT_BOLD);
        this.setTextSize(2, 11.0f);
        this.setPadding(this.dip2Px(5.0f), this.dip2Px(1.0f), this.dip2Px(5.0f), this.dip2Px(1.0f));
        this.setClickable(false);
        this.setFocusable(false);
        this.setBackground(3.2f, Color.parseColor((String)"#FA3F45"));
        this.setGravity(17);
        this.setHideOnNull(true);
        this.setBadgeCount(0);
    }

    public void setBackground(float dipRadius, int badgeColor) {
        int radius = this.dip2Px(dipRadius);
        float[] radiusArray = new float[]{radius, radius, radius, radius, radius, radius, radius, radius};
        RoundRectShape roundRect = new RoundRectShape(radiusArray, null, null);
        ShapeDrawable bgDrawable = new ShapeDrawable((Shape)roundRect);
        bgDrawable.getPaint().setColor(badgeColor);
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground((Drawable)bgDrawable);
        } else {
            this.setBackgroundDrawable((Drawable)bgDrawable);
        }
    }

    public boolean isHideOnNull() {
        return this.mHideOnNull;
    }

    public void setHideOnNull(boolean hideOnNull) {
        this.mHideOnNull = hideOnNull;
        this.setText(this.getText());
    }

    public void setIsShow(boolean show) {
        if (this.mIsShow != show) {
            this.mIsShow = show;
            this.setText(this.getText());
        }
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        if (!this.mIsShow) {
            this.setVisibility(8);
        } else if (this.isHideOnNull() && (text == null || text.toString().equalsIgnoreCase("0"))) {
            this.setVisibility(8);
        } else {
            this.setVisibility(0);
        }
        super.setText(text, type);
    }

    public void showBadgeRedDot(boolean isShow2) {
        this.setIsShow(isShow2);
        if (isShow2) {
            this.setText("");
            this.setHeight(this.dip2Px(7.0f));
            this.setWidth(this.dip2Px(7.0f));
        }
    }

    public void setBadgeCount(int count) {
        this.setIsShow(true);
        this.setText(String.valueOf(count));
    }

    public Integer getBadgeCount() {
        if (this.getText() == null) {
            return null;
        }
        String text = this.getText().toString();
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public void setBadgeGravity(int gravity) {
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.getLayoutParams();
        params.gravity = gravity;
        this.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public int getBadgeGravity() {
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.getLayoutParams();
        return params.gravity;
    }

    public void setBadgeMargin(int dipMargin) {
        this.setBadgeMargin(dipMargin, dipMargin, dipMargin, dipMargin);
    }

    public void setBadgeMargin(int leftDipMargin, int topDipMargin, int rightDipMargin, int bottomDipMargin) {
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.getLayoutParams();
        params.leftMargin = this.dip2Px(leftDipMargin);
        params.topMargin = this.dip2Px(topDipMargin);
        params.rightMargin = this.dip2Px(rightDipMargin);
        params.bottomMargin = this.dip2Px(bottomDipMargin);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public int[] getBadgeMargin() {
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.getLayoutParams();
        return new int[]{params.leftMargin, params.topMargin, params.rightMargin, params.bottomMargin};
    }

    public void incrementBadgeCount(int increment) {
        Integer count = this.getBadgeCount();
        if (count == null) {
            this.setBadgeCount(increment);
        } else {
            this.setBadgeCount(increment + count);
        }
    }

    public void decrementBadgeCount(int decrement) {
        this.incrementBadgeCount(-decrement);
    }

    public void setTargetView(TabWidget target, int tabIndex) {
        View tabView = target.getChildTabViewAt(tabIndex);
        this.setTargetView(tabView);
    }

    public void setTargetView(View target) {
        if (this.getParent() != null) {
            ((ViewGroup)this.getParent()).removeView((View)this);
        }
        if (target == null) {
            return;
        }
        if (target.getParent() instanceof FrameLayout) {
            ((FrameLayout)target.getParent()).addView((View)this);
        } else if (target.getParent() instanceof ViewGroup) {
            ViewGroup parentContainer = (ViewGroup)target.getParent();
            int groupIndex = parentContainer.indexOfChild(target);
            parentContainer.removeView(target);
            FrameLayout badgeContainer = new FrameLayout(this.getContext());
            ViewGroup.LayoutParams parentLayoutParams = target.getLayoutParams();
            badgeContainer.setLayoutParams(parentLayoutParams);
            target.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            parentContainer.addView((View)badgeContainer, groupIndex, parentLayoutParams);
            badgeContainer.addView(target);
            badgeContainer.addView((View)this);
        } else if (target.getParent() == null) {
            Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"ParentView is needed");
        }
    }

    private int dip2Px(float dip) {
        return (int)(dip * this.getContext().getResources().getDisplayMetrics().density + 0.5f);
    }

    public static BadgeView findFrom(ViewGroup view) {
        if (view instanceof FrameLayout) {
            FrameLayout f = (FrameLayout)view;
            int count = f.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = f.getChildAt(i);
                if (!(child instanceof BadgeView)) continue;
                BadgeView badge = (BadgeView)child;
                return badge;
            }
        }
        return null;
    }
}

