/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.router;

import android.content.Context;
import com.yy.mobile.android.arouter.facade.Postcard;
import com.yy.mobile.android.arouter.facade.annotation.Interceptor;
import com.yy.mobile.android.arouter.facade.callback.InterceptorCallback;
import com.yy.mobile.android.arouter.facade.template.IInterceptor;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.router.NetworkCheckInterceptor;
import com.yy.mobile.util.NetworkUtils;
import io.reactivex.android.schedulers.AndroidSchedulers;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/yy/mobile/router/NetworkCheckInterceptor;", "Lcom/yy/mobile/android/arouter/facade/template/IInterceptor;", "()V", "hasNetworkCheckFlag", "", "extra", "", "init", "", "context", "Landroid/content/Context;", "process", "postcard", "Lcom/yy/mobile/android/arouter/facade/Postcard;", "callback", "Lcom/yy/mobile/android/arouter/facade/callback/InterceptorCallback;", "pluginunionmain_release"})
@Interceptor(priority=6, name="\u68c0\u67e5\u7f51\u7edc")
public final class NetworkCheckInterceptor
implements IInterceptor {
    public void process(@NotNull Postcard postcard, @NotNull InterceptorCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)postcard, (String)"postcard");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        if (this.hasNetworkCheckFlag(postcard.getExtra())) {
            BasicConfig basicConfig = BasicConfig.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)basicConfig, (String)"BasicConfig.getInstance()");
            if (!NetworkUtils.isNetworkAvailable((Context)basicConfig.getAppContext())) {
                AndroidSchedulers.mainThread().scheduleDirect((Runnable)process.1.INSTANCE);
                callback.onInterrupt((Throwable)new RuntimeException("\u7f51\u7edc\u4e0d\u7ed9\u529b"));
                return;
            }
        }
        callback.onContinue(postcard);
    }

    public void init(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
    }

    private final boolean hasNetworkCheckFlag(int extra) {
        return (extra & 8) == 8;
    }
}

