/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.yyapi;

import android.graphics.Rect;
import android.support.v4.util.ArrayMap;
import com.duowan.mobile.entlive.events.IDanmuViewBasicClient_setDanMuLines_EventArgs;
import com.duowan.mobile.entlive.events.IPluginsClient_onChangeCameraFront_EventArgs;
import com.duowan.mobile.entlive.events.IPluginsClient_onChangeDanMu_EventArgs;
import com.duowan.mobile.entlive.events.IPluginsClient_onChangeOrientation_EventArgs;
import com.duowan.mobile.entlive.events.IPluginsClient_onChangeStickerIcon_EventArgs;
import com.duowan.mobile.entlive.events.IPluginsClient_onPluginStateChange_EventArgs;
import com.yy.mobile.RxBus;
import com.yy.mobile.liveapi.pk.IPkCore;
import com.yy.mobile.liveapi.plugins.IPluginRenderApi;
import com.yy.mobile.plugin.Plugins;
import com.yy.mobile.plugin.pluginunionlive.PluginBus;
import com.yy.mobile.ui.plugins.BasePluginViewController;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.yyapi.event.ChangEntTemplate;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.mobilelive.IMobileLiveCore;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class PluginRenderApiImpl
extends IPluginRenderApi {
    public static final int CHANGE_TO_UNACTIVE_STATE = 2;
    public static final int CHANGE_TO_ACTIVE_STATE = 1;
    public static final int NO_CHANGE_STATE = 0;
    private static final String TAG = "PluginRenderApiImpl";
    private int mCTX;
    private Map<String, WeakReference<BasePluginViewController>> mHostControllers = new ArrayMap();
    private Map<String, WeakReference<BasePluginViewController>> mGuestControllers = new ArrayMap();
    private HashMap<String, IPluginRenderApi.State> pluginsReadyState = new HashMap();
    private int greedyFaceRenderLevel;

    public void init(int ctx) {
        this.mCTX = ctx;
    }

    public IPluginRenderApi.State getPluginState(String pluginId) {
        if (!FP.empty(this.pluginsReadyState) && this.pluginsReadyState.containsKey(pluginId)) {
            return this.pluginsReadyState.get(pluginId);
        }
        return IPluginRenderApi.State.UN_READY_STATE;
    }

    public BasePluginViewController getCurrentUsingController(boolean isHost) {
        for (Map.Entry<String, WeakReference<BasePluginViewController>> entry : isHost ? this.mHostControllers.entrySet() : this.mGuestControllers.entrySet()) {
            if (!this.pluginsReadyState.containsKey(entry.getKey())) continue;
            return (BasePluginViewController)((Object)entry.getValue().get());
        }
        return null;
    }

    public void setPluginState(String pluginId, IPluginRenderApi.State state) {
        if (state == IPluginRenderApi.State.UN_READY_STATE) {
            this.onPluginOpenOrClose(pluginId, false);
        }
        MLog.info((Object)TAG, (String)"setPluginState,pluginId:%s,state:%s", (Object[])new Object[]{pluginId, state});
        if (this.pluginsReadyState != null) {
            this.pluginsReadyState.put(pluginId, state);
            if (Plugins.Arena.pluginId().equals(pluginId)) {
                RxBus.getDefault().post((Object)new IPluginsClient_onChangeOrientation_EventArgs(this.needChangeOrientation(pluginId, state)));
                return;
            }
            RxBus.getDefault().post((Object)new IPluginsClient_onPluginStateChange_EventArgs(pluginId, state));
            RxBus.getDefault().post((Object)new IPluginsClient_onChangeDanMu_EventArgs(this.needChangeDanmu(pluginId, state)));
            RxBus.getDefault().post((Object)new IPluginsClient_onChangeCameraFront_EventArgs(this.needChangeCameraFront(pluginId, state)));
            RxBus.getDefault().post((Object)new IPluginsClient_onChangeOrientation_EventArgs(this.needChangeOrientation(pluginId, state)));
            RxBus.getDefault().post((Object)new IPluginsClient_onChangeStickerIcon_EventArgs(this.needChangeStickerIcon(pluginId, state)));
        }
    }

    public void addPluginController(Map<String, WeakReference<BasePluginViewController>> controllers, BasePluginViewController controller) {
        MLog.info((Object)TAG, (String)"addPluginController", (Object[])new Object[0]);
        if (controller == null) {
            MLog.info((Object)TAG, (String)"addPluginController, controller is null", (Object[])new Object[0]);
            return;
        }
        if (controllers == null) {
            MLog.info((Object)TAG, (String)"addPluginController, controllers is null", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"addPluginController %s, success. ", (Object[])new Object[]{controller.getPluginId()});
        controllers.put(controller.getPluginId(), new WeakReference<BasePluginViewController>(controller));
    }

    public void addPluginController(boolean isHost, BasePluginViewController controller) {
        MLog.info((Object)TAG, (String)"addPluginController isHost = %b", (Object[])new Object[]{isHost});
        this.addPluginController(isHost ? this.mHostControllers : this.mGuestControllers, controller);
    }

    public void clearPluginController(String pluginId, boolean isHost) {
        if (FP.empty((CharSequence)pluginId)) {
            MLog.info((Object)TAG, (String)"clearPluginController pluginId is null", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"clearPluginController isHost = %b,pluginId=%s", (Object[])new Object[]{isHost, pluginId});
        this.clearController(pluginId, isHost ? this.mHostControllers : this.mGuestControllers);
        if (!FP.empty(this.pluginsReadyState) && this.pluginsReadyState.containsKey(pluginId)) {
            this.pluginsReadyState.remove(pluginId);
        }
    }

    public void clearController(String pluginId, Map<String, WeakReference<BasePluginViewController>> controllers) {
        MLog.info((Object)TAG, (String)"clearController", (Object[])new Object[0]);
        if (!FP.empty(controllers) && controllers.containsKey(pluginId)) {
            WeakReference<BasePluginViewController> controller = controllers.get(pluginId);
            controller.clear();
            controllers.remove(pluginId);
        }
    }

    public void reset(int ctx) {
        if (this.mCTX == ctx) {
            this.mHostControllers.clear();
            this.mGuestControllers.clear();
            this.pluginsReadyState.clear();
        }
    }

    public int requestParentViewGroup(String pluginId, int type) {
        this.onPluginOpenOrClose(pluginId, true);
        MLog.info((Object)TAG, (String)"requestParentViewGroup,pluginId:%s", (Object[])new Object[]{pluginId});
        BasePluginViewController controller = null;
        controller = ((IMobileLiveCore)CoreFactory.getCore(IMobileLiveCore.class)).isLoginUserMobileLive() ? this.getController(pluginId, this.mHostControllers) : this.getController(pluginId, this.mGuestControllers);
        if (controller != null) {
            controller.deliverViewGroupToPlugin();
            return 0;
        }
        return -1;
    }

    private BasePluginViewController getController(String pluginId, Map<String, WeakReference<BasePluginViewController>> controllers) {
        if (!FP.empty(controllers) && controllers.containsKey(pluginId)) {
            return (BasePluginViewController)((Object)controllers.get(pluginId).get());
        }
        return null;
    }

    public boolean canBeInvited() {
        return false;
    }

    public String getCantBeInvitedReason() {
        String reason = "";
        if (((IPkCore)ICoreManagerBase.getCore(IPkCore.class)).isInPKing()) {
            reason = "\u201c\u6b22\u4e50\u6597\u201d";
        }
        MLog.info((Object)TAG, (String)("getCantBeInvitedReason: " + reason), (Object[])new Object[0]);
        return String.format("\u5bf9\u65b9\u6b63\u5728%s\u4e2d\uff0c\u7a0d\u540e\u518d\u8bd5", reason);
    }

    public void setGuestDanMuLines(int lines, Rect margin) {
        MLog.info((Object)TAG, (String)("setGuestDanMuLines: " + lines + ", " + margin), (Object[])new Object[0]);
        PluginBus.INSTANCE.get().post((Object)new IDanmuViewBasicClient_setDanMuLines_EventArgs(lines, margin, true));
    }

    public boolean isPluginLianMai() {
        return false;
    }

    public boolean existPluginStateOf(IPluginRenderApi.State state) {
        for (Plugins game : Plugins.getLiveroomGames()) {
            if (this.getPluginState(game.pluginId()) != state) continue;
            return true;
        }
        return false;
    }

    public int getGreedyFaceRenderLevel() {
        return this.greedyFaceRenderLevel;
    }

    public void setGreedyFaceRenderLevel(int greedyFaceRenderLevel) {
        MLog.info((Object)TAG, (String)("setGreedyFaceRenderLevel : " + greedyFaceRenderLevel), (Object[])new Object[0]);
        this.greedyFaceRenderLevel = greedyFaceRenderLevel;
    }

    public int needChangeDanmu(String pluginId, IPluginRenderApi.State state) {
        block3: {
            block2: {
                if (state != IPluginRenderApi.State.SELF_PLAYING_STATE && state != IPluginRenderApi.State.PK_PLAYING_STATE) break block2;
                for (Plugins game : Plugins.getLiveroomGames()) {
                    if (!game.pluginId().equals(pluginId)) continue;
                    return 1;
                }
                break block3;
            }
            if (state != IPluginRenderApi.State.UN_READY_STATE) break block3;
            for (Plugins game : Plugins.getLiveroomGames()) {
                if (!game.pluginId().equals(pluginId)) continue;
                return 2;
            }
        }
        return 0;
    }

    public int needChangeCameraFront(String pluginId, IPluginRenderApi.State state) {
        if (state == IPluginRenderApi.State.SELF_PLAYING_STATE) {
            for (Plugins game : Plugins.getLiveroomGames()) {
                if (!game.pluginId().equals(pluginId)) continue;
                return 1;
            }
        } else if (state == IPluginRenderApi.State.PK_PLAYING_STATE && Plugins.FaceLiminate.equals((Object)pluginId)) {
            return 1;
        }
        return 0;
    }

    public int needChangeOrientation(String pluginId, IPluginRenderApi.State state) {
        if (state == IPluginRenderApi.State.SELF_PLAYING_STATE) {
            for (Plugins game : Plugins.getLiveroomGames()) {
                if (!game.pluginId().equals(pluginId)) continue;
                return 1;
            }
        } else if (state == IPluginRenderApi.State.PK_PLAYING_STATE) {
            if (Plugins.FaceLiminate.pluginId().equals(pluginId)) {
                return 1;
            }
            if (Plugins.Arena.pluginId().equals(pluginId)) {
                return 1;
            }
        }
        return 0;
    }

    public int needChangeStickerIcon(String pluginId, IPluginRenderApi.State state) {
        if (Plugins.GreedyFace.pluginId().equals(pluginId) && (state == IPluginRenderApi.State.SELF_PLAYING_STATE || state == IPluginRenderApi.State.PK_PLAYING_STATE)) {
            return 1;
        }
        return 0;
    }

    private void onPluginOpenOrClose(String pluginId, boolean open) {
        MLog.info((Object)TAG, (String)"\u73a9\u6cd5\uff1a %s, isStart: %b", (Object[])new Object[]{pluginId, open});
        if ("34".equals(pluginId)) {
            RxBus.getDefault().post((Object)new ChangEntTemplate(!open));
        }
    }
}

