/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.imageloader.transform.YYBitmapTransformation;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.log.MLog;

public class CountDownButton
extends FrameLayout {
    private static final String TAG = "CountDownButton";
    private TextView mMainText;
    private TextView mCountDownText;
    private String mTimeUnit = "s";
    private int mCountDownSeconds;
    private boolean mHideOnCountDown = false;
    private OnCountDownListener mCountDownListener;
    private Handler mHandler = new SafeDispatchHandler(Looper.getMainLooper());
    private Runnable mCountDownTask = new Runnable(){

        @Override
        public void run() {
            --CountDownButton.this.mCountDownSeconds;
            if (CountDownButton.this.mCountDownSeconds > 0) {
                CountDownButton.this.doCountDown();
            } else {
                CountDownButton.this.stopCountDown();
            }
        }
    };

    public CountDownButton(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public CountDownButton(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public CountDownButton(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public CountDownButton(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.log("onAttachedToWindow");
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeCountDownTask();
        this.log("onDetachedFromWindow");
    }

    private void log(String msg) {
        MLog.info((Object)TAG, (String)("msg=" + msg), (Object[])new Object[0]);
    }

    private void removeCountDownTask() {
        this.mHandler.removeCallbacks(this.mCountDownTask);
        MLog.info((Object)TAG, (String)"removeCountDownTask", (Object[])new Object[0]);
    }

    private void enqueueCountDownTask() {
        boolean isPostSuccess = this.mHandler.postDelayed(this.mCountDownTask, 1000L);
        MLog.info((Object)TAG, (String)("enqueueCountDownTask=" + isPostSuccess), (Object[])new Object[0]);
    }

    private void init(Context context, @Nullable AttributeSet attrs) {
        CountDownButton.inflate((Context)context, (int)R.layout.view_time_count_down, (ViewGroup)this);
        this.mMainText = (TextView)this.findViewById(R.id.tv_base);
        this.mCountDownText = (TextView)this.findViewById(R.id.tv_elapse);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CountDownButton);
        int count = a.getIndexCount();
        for (int i = 0; i < count; ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.CountDownButton_mainBackground) {
                this.mMainText.setBackgroundDrawable(a.getDrawable(attr2));
                continue;
            }
            if (attr2 == R.styleable.CountDownButton_mainText) {
                this.mMainText.setText(a.getText(attr2));
                continue;
            }
            if (attr2 == R.styleable.CountDownButton_mainTextColor) {
                this.mMainText.setTextColor(a.getColor(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.CountDownButton_mainTextSize) {
                this.mMainText.setTextSize(0, (float)a.getDimensionPixelSize(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.CountDownButton_countDownBackground) {
                this.mCountDownText.setBackgroundDrawable(a.getDrawable(attr2));
                continue;
            }
            if (attr2 == R.styleable.CountDownButton_countDownTextColor) {
                this.mCountDownText.setTextColor(a.getColor(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.CountDownButton_countDownTextSize) {
                this.mCountDownText.setTextSize(0, (float)a.getDimensionPixelSize(attr2, 0));
                continue;
            }
            if (attr2 != R.styleable.CountDownButton_hideOnCountdown) continue;
            this.mHideOnCountDown = a.getBoolean(attr2, false);
        }
        a.recycle();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mMainText.setEnabled(enabled);
        this.mCountDownText.setEnabled(enabled);
    }

    public void setCountDownTextColor(int color2) {
        this.mCountDownText.setTextColor(color2);
    }

    public void setCountDownBackground(int color2) {
        this.mCountDownText.setBackgroundColor(color2);
    }

    public void setCountDownBackgroundResource(int resId) {
        this.mCountDownText.setBackgroundResource(resId);
    }

    public void setMainTextColor(int color2) {
        this.mMainText.setTextColor(color2);
    }

    public void setMainBackground(int color2) {
        this.mMainText.setBackgroundColor(color2);
    }

    public void setMainBackgroundResource(int resId) {
        this.mMainText.setBackgroundResource(resId);
    }

    public void setMainBackgroundUrl(String url, YYBitmapTransformation ... transformations) {
        int w = ImageConfig.fullImageConfig().getImagePrecision().getWidth();
        int h = ImageConfig.fullImageConfig().getImagePrecision().getHeight();
        ImageLoader.loadBitmap((Context)this.getContext(), (String)url, (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

            public void onLoadFailed(Exception e) {
            }

            public void onResourceReady(Bitmap bitmap) {
                BitmapDrawable drawable2 = new BitmapDrawable(bitmap);
                CountDownButton.this.mMainText.setBackgroundDrawable((Drawable)drawable2);
            }
        }, (int)w, (int)h, (boolean)false, (YYBitmapTransformation[])transformations);
    }

    public String getTimeUnit() {
        return this.mTimeUnit;
    }

    public void setTimeUnit(String timeUnit) {
        this.mTimeUnit = timeUnit;
    }

    public void setMainText(String text) {
        this.mMainText.setText((CharSequence)text);
    }

    public void setCountDownListener(OnCountDownListener listener2) {
        this.mCountDownListener = listener2;
    }

    public void startCountDown(int seconds) {
        this.log("startCountDown");
        this.removeCountDownTask();
        this.mCountDownSeconds = seconds;
        this.mCountDownText.setVisibility(0);
        this.mMainText.setVisibility(this.mHideOnCountDown ? 8 : 0);
        this.doCountDown();
        if (this.mCountDownListener != null) {
            this.mCountDownListener.onStart(this);
        }
    }

    public void stopCountDown() {
        this.log("stopCountDown");
        this.removeCountDownTask();
        this.mCountDownText.setVisibility(8);
        this.mMainText.setVisibility(0);
        if (this.mCountDownListener != null) {
            this.mCountDownListener.onStop(this);
        }
    }

    private void doCountDown() {
        this.log("doCountDown");
        this.mCountDownText.setText((CharSequence)(String.valueOf(this.mCountDownSeconds) + this.mTimeUnit));
        this.enqueueCountDownTask();
    }

    public static interface OnCountDownListener {
        public void onStart(CountDownButton var1);

        public void onStop(CountDownButton var1);
    }
}

